/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecurityDefaultParametersBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ParameterIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BasicAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BearerAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.DigestAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BasicAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BearerAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.DigestAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2Scheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.PassThroughScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.UnsecuredScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.ComparisonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class SecuritySchemeBuilder {
    private ConnectorSecurityScheme.SecuritySchemeType type;
    private final String name;
    private final List<ParameterBuilder> nonStandardHeaderBuilders = new ArrayList<ParameterBuilder>();
    private final List<ParameterBuilder> nonStandardQueryParameterBuilders = new ArrayList<ParameterBuilder>();
    private final SecurityDefaultParametersBuilder securityDefaultParametersBuilder = new SecurityDefaultParametersBuilder();
    private String alias;
    private TestConnectionConfig testConnectionConfig;
    private String authorizationUri;
    private String accessTokenUri;
    private List<String> scopes;
    private String refreshTokenConditionExpression;
    private OAuth2Scheme.GrantType grantType;
    private Boolean ignored;
    private Boolean refined;
    private String fqn;

    public SecuritySchemeBuilder(String name, ConnectorSecurityScheme.SecuritySchemeType type) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public ConnectorSecurityScheme.SecuritySchemeType getType() {
        return this.type;
    }

    public Boolean isIgnored() {
        return this.ignored;
    }

    public ParameterBuilder getOrCreateParameterBuilder(ParameterType parameterType, String name) {
        List<ParameterBuilder> parameterBuilders = this.getParameterBuilders(parameterType);
        ParameterBuilder paramBuilder = parameterBuilders.stream().filter(x -> ComparisonUtil.externalNameParamsComparison(x.getExternalName(), name, parameterType)).findFirst().orElse(null);
        if (paramBuilder == null) {
            String parameterIdentifier = null;
            paramBuilder = new ParameterBuilder(parameterType, name, parameterIdentifier);
            parameterBuilders.add(paramBuilder);
        }
        return paramBuilder;
    }

    private List<ParameterBuilder> getParameterBuilders(ParameterType parameterType) {
        switch (parameterType) {
            case QUERY: {
                return this.nonStandardQueryParameterBuilders;
            }
            case HEADER: {
                return this.nonStandardHeaderBuilders;
            }
        }
        throw new IllegalArgumentException("Parameter Type not supported. This is a bug.");
    }

    public SecuritySchemeBuilder testConnectionConfig(TestConnectionConfig testConnectionConfig) {
        this.testConnectionConfig = (TestConnectionConfig)ObjectUtils.defaultIfNull((Object)testConnectionConfig, (Object)this.testConnectionConfig);
        return this;
    }

    public SecurityDefaultParametersBuilder getSecurityDefaultParametersBuilder() {
        return this.securityDefaultParametersBuilder;
    }

    public SecuritySchemeBuilder authorizationUri(String authorizationUri) {
        this.authorizationUri = (String)ObjectUtils.defaultIfNull((Object)authorizationUri, (Object)this.authorizationUri);
        return this;
    }

    public SecuritySchemeBuilder accessTokenUri(String accessTokenUri) {
        this.accessTokenUri = (String)ObjectUtils.defaultIfNull((Object)accessTokenUri, (Object)this.accessTokenUri);
        return this;
    }

    public SecuritySchemeBuilder scopes(List<String> scopes) {
        this.scopes = (List)ObjectUtils.defaultIfNull(scopes, this.scopes);
        return this;
    }

    public SecuritySchemeBuilder refreshTokenConditionExpression(String refreshTokenConditionExpression) {
        this.refreshTokenConditionExpression = (String)ObjectUtils.defaultIfNull((Object)refreshTokenConditionExpression, (Object)this.refreshTokenConditionExpression);
        return this;
    }

    public SecuritySchemeBuilder grantType(OAuth2Scheme.GrantType grantType) {
        this.grantType = (OAuth2Scheme.GrantType)((Object)ObjectUtils.defaultIfNull((Object)((Object)grantType), (Object)((Object)this.grantType)));
        return this;
    }

    public SecuritySchemeBuilder ignored(Boolean ignored) {
        this.ignored = (Boolean)ObjectUtils.defaultIfNull((Object)ignored, (Object)this.ignored);
        return this;
    }

    public SecuritySchemeBuilder refined(Boolean refined) {
        this.refined = (Boolean)ObjectUtils.defaultIfNull((Object)refined, (Object)this.refined);
        return this;
    }

    public SecuritySchemeBuilder alias(String alias) {
        this.alias = alias;
        return this;
    }

    public SecuritySchemeBuilder fqn(String fqn) {
        this.fqn = fqn;
        return this;
    }

    protected boolean isRefined() {
        return (Boolean)ObjectUtils.defaultIfNull((Object)this.refined, (Object)false);
    }

    public ConnectorSecurityScheme build(TypeSchemaPool typeSchemaPool, TestConnectionConfig defaultTestConnectionConfig, ParameterIdentifierExpressionHandler parameterIdExpressionHandler) {
        TestConnectionConfig testConnectionConfig = (TestConnectionConfig)ObjectUtils.defaultIfNull((Object)this.testConnectionConfig, (Object)defaultTestConnectionConfig);
        switch (this.type) {
            case BASIC: {
                return this.buildBasicAuthScheme(testConnectionConfig);
            }
            case CUSTOM_AUTHENTICATION: {
                return this.buildCustomAuthenticationScheme(typeSchemaPool, parameterIdExpressionHandler, testConnectionConfig);
            }
            case DIGEST_AUTHENTICATION: {
                return this.buildDigestAuthenticationSchemeScheme(testConnectionConfig);
            }
            case PASS_THROUGH: {
                return this.buildPassThroughScheme(typeSchemaPool, parameterIdExpressionHandler, testConnectionConfig);
            }
            case OAUTH2: {
                return this.buildOauth2Scheme(typeSchemaPool, parameterIdExpressionHandler, testConnectionConfig);
            }
            case BEARER: {
                return this.buildBearerAuthScheme(testConnectionConfig);
            }
            case UNSECURED: 
            case NOT_SUPPORTED: {
                return this.buildUnsecuredScheme(testConnectionConfig);
            }
        }
        throw new IllegalArgumentException("Security scheme '" + (Object)((Object)this.type) + "' is not supported. This is a bug.");
    }

    private ConnectorSecurityScheme buildOauth2Scheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdExpressionHandler, TestConnectionConfig testConnectionConfig) {
        Objects.requireNonNull(this.grantType);
        if (this.grantType.equals((Object)OAuth2Scheme.GrantType.AUTHORIZATION_CODE)) {
            return this.buildOAuth2AuthorizationCodeScheme(typeSchemaPool, parameterIdExpressionHandler, testConnectionConfig);
        }
        if (this.grantType.equals((Object)OAuth2Scheme.GrantType.CLIENT_CREDENTIALS)) {
            return this.buildOAuth2ClientCredentialsScheme(typeSchemaPool, parameterIdExpressionHandler, testConnectionConfig);
        }
        throw new IllegalArgumentException("Grant type not supported. This is a bug.");
    }

    private BasicAuthScheme buildBasicAuthScheme(TestConnectionConfig testConnectionConfig) {
        SecurityDefaultParameters securityDefaultParameters = this.securityDefaultParametersBuilder.build();
        if (securityDefaultParameters == null || securityDefaultParameters instanceof BasicAuthDefaultParameters) {
            return new BasicAuthScheme(this.name, this.alias, (BasicAuthDefaultParameters)securityDefaultParameters, testConnectionConfig, this.isRefined());
        }
        throw new IllegalArgumentException("Default parameters not corresponding to the security scheme type: basic. This is a bug.");
    }

    private CustomAuthenticationScheme buildCustomAuthenticationScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new CustomAuthenticationScheme(this.name, this.alias, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdExpressionHandler), testConnectionConfig, this.isRefined(), this.fqn);
    }

    private DigestAuthenticationScheme buildDigestAuthenticationSchemeScheme(TestConnectionConfig testConnectionConfig) {
        SecurityDefaultParameters securityDefaultParameters = this.securityDefaultParametersBuilder.build();
        if (securityDefaultParameters == null || securityDefaultParameters instanceof DigestAuthDefaultParameters) {
            return new DigestAuthenticationScheme(this.name, this.alias, (DigestAuthDefaultParameters)securityDefaultParameters, testConnectionConfig, this.isRefined());
        }
        throw new IllegalArgumentException("Default parameters not corresponding to the security scheme type: digest. This is a bug.");
    }

    private OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new OAuth2AuthorizationCodeScheme(this.name, this.alias, this.authorizationUri, this.accessTokenUri, this.scopes, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdExpressionHandler), testConnectionConfig, this.refreshTokenConditionExpression, this.isRefined());
    }

    private OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new OAuth2ClientCredentialsScheme(this.name, this.alias, this.authorizationUri, this.accessTokenUri, this.scopes, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdExpressionHandler), testConnectionConfig, this.refreshTokenConditionExpression, this.isRefined());
    }

    private PassThroughScheme buildPassThroughScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new PassThroughScheme(this.name, this.alias, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdExpressionHandler), testConnectionConfig, this.isRefined());
    }

    private UnsecuredScheme buildUnsecuredScheme(TestConnectionConfig testConnectionConfig) {
        return new UnsecuredScheme(testConnectionConfig, this.isRefined());
    }

    private BearerAuthScheme buildBearerAuthScheme(TestConnectionConfig testConnectionConfig) {
        SecurityDefaultParameters securityDefaultParameters = this.securityDefaultParametersBuilder.build();
        if (securityDefaultParameters == null || securityDefaultParameters instanceof BearerAuthDefaultParameters) {
            return new BearerAuthScheme(this.name, this.alias, (BearerAuthDefaultParameters)securityDefaultParameters, testConnectionConfig, this.isRefined());
        }
        throw new IllegalArgumentException("Default parameters not corresponding to the security scheme type: bearer. This is a bug.");
    }

    private List<Parameter> buildNonStandardQueryParameters(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdExpressionHandler) {
        return this.nonStandardQueryParameterBuilders.stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(x -> x.buildParameter(typeSchemaPool, parameterIdExpressionHandler)).collect(Collectors.toList());
    }

    private List<Parameter> buildNonStandardHeaders(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdExpressionHandler) {
        return this.nonStandardHeaderBuilders.stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(x -> x.buildParameter(typeSchemaPool, parameterIdExpressionHandler)).collect(Collectors.toList());
    }

    public void setType(ConnectorSecurityScheme.SecuritySchemeType type) {
        if (!type.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION) && !this.type.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.UNSECURED)) {
            throw new IllegalStateException("\nthis method can only be called if the received security type is CUSTOM_AUTHENTICATION and the class type is UNSECURED. this is a bug");
        }
        this.type = type;
    }
}

