/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri.Type.MULTIPLE;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseUriBuilder {

  private String uri;
  private BaseUri.Type type;
  private String apiVersion;

  private String defaultUriId;
  private final Map<String, String> uriMappings = new HashMap<>();

  public BaseUriBuilder setUri(String uri) {
    this.uri = defaultIfNull(uri, this.uri);
    return this;
  }

  public boolean hasUri() {
    return (isNotBlank(uri)) ||
        uriMappings.values().stream().anyMatch(StringUtils::isNotBlank);
  }

  public BaseUriBuilder setType(BaseUri.Type type) {
    requireNonNull(type);
    this.type = type;
    return this;
  }

  public BaseUriBuilder setApiVersion(String apiVersion) {
    this.apiVersion = defaultIfNull(apiVersion, this.apiVersion);
    return this;
  }

  public BaseUriBuilder addMultipleBaseUri(String uriId, String uri, boolean isDefaultUri) {
    requireNonNull(uriId);
    requireNonNull(uri);

    this.type = MULTIPLE;

    if (isDefaultUri) {
      this.defaultUriId = uriId;
    }

    this.uriMappings.put(uriId, uri);

    return this;
  }

  BaseUri build(List<Protocol> supportedProtocols) {
    requireNonNull(type);

    if (type.equals(MULTIPLE)) {
      return new BaseUri(uriMappings, defaultUriId, apiVersion, supportedProtocols);
    } else {
      return new BaseUri(uri, type, apiVersion, supportedProtocols);
    }
  }
}
