/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorInterceptor;

import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

public class InterceptorBuilder {

  private String expression;
  private String reasonPhrase;
  private String statusCode;
  private String headers;
  private String body;
  private boolean isOnError;

  public InterceptorBuilder() {}

  public String getExpression() {
    return expression;
  }

  public String getReasonPhrase() {
    return reasonPhrase;
  }

  public String getStatusCode() {
    return statusCode;
  }

  public String getHeaders() {
    return headers;
  }

  public String getBody() {
    return body;
  }

  public boolean isOnError() {
    return isOnError;
  }

  public InterceptorBuilder expression(String expression) {
    this.expression = defaultIfNull(expression, this.expression);
    return this;
  }

  public InterceptorBuilder reasonPhrase(String reasonPhrase) {
    this.reasonPhrase = defaultIfNull(reasonPhrase, this.reasonPhrase);
    return this;
  }

  public InterceptorBuilder statusCode(String statusCode) {
    this.statusCode = defaultIfNull(statusCode, this.statusCode);
    return this;
  }

  public InterceptorBuilder headers(String headers) {
    this.headers = defaultIfNull(headers, this.headers);
    return this;
  }

  public InterceptorBuilder body(String body) {
    this.body = defaultIfNull(body, this.body);
    return this;
  }

  public InterceptorBuilder isOnError(boolean isOnError) {
    this.isOnError = defaultIfNull(isOnError, this.isOnError);
    return this;
  }

  //
  ConnectorInterceptor build() {

    ConnectorInterceptor interceptor = new ConnectorInterceptor(expression,
                                                                reasonPhrase,
                                                                statusCode,
                                                                headers,
                                                                body,
                                                                isOnError);

    return interceptor;
  }
}
