/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameter;

import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

public class SecurityDefaultParameterBuilder {

  private String displayName;
  private String description;


  public SecurityDefaultParameterBuilder displayName(String displayName) {
    this.displayName = defaultIfNull(displayName, this.displayName);
    return this;
  }

  public SecurityDefaultParameterBuilder description(String description) {
    this.description = defaultIfNull(description, this.description);
    return this;
  }


  public SecurityDefaultParameter build() {
    return new SecurityDefaultParameter(displayName, description);
  }
}
