/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.LiteralExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverParameter;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverParameterDescriptor;

import java.util.List;

public class DescriptorResolverLoader {

  static List<ResolverParameter> loadResolverParameters(List<ResolverParameterDescriptor> parameters) {
    return parameters.stream()
        .map(x -> new ResolverParameter(x.getName(), ParameterDataType.forName(x.getDataType().getName())))
        .collect(toList());
  }

  static List<Argument> loadResolverArguments(List<ResolverArgumentDescriptor> arguments) {
    return arguments.stream()
        .map(x -> new Argument(x.getName(), new LiteralExpression(x.getValue().getExpression())))
        .collect(toList());
  }
}
