/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static org.apache.commons.lang3.StringUtils.isEmpty;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;

import javax.ws.rs.core.MediaType;

public class DescriptorTypeLoader {

  static void loadDataType(ParameterDescriptor parameterDescriptor, TypeDefinitionBuilder connectorTypeDefinitionBuilder) {

    if (parameterDescriptor.getDataType() == null) {
      return;
    }

    connectorTypeDefinitionBuilder.primitive(loadPrimitiveType(parameterDescriptor.getDataType()));
  }

  static PrimitiveTypeDefinition.PrimitiveType loadPrimitiveType(DataTypeDescriptor dataType) {
    switch (dataType) {
      case STRING:
        return PrimitiveTypeDefinition.PrimitiveType.STRING;
      case INTEGER:
        return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
      case LONG:
        return PrimitiveTypeDefinition.PrimitiveType.LONG;
      case NUMBER:
        return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
      case ZONED_DATE_TIME:
        return PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME;
      case LOCAL_DATE_TIME:
        return PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME;
      case BOOLEAN:
        return PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
      default:
        throw new IllegalArgumentException("Primitive Type not supported. This is a bug.");
    }
  }

  static MediaType loadMediaType(String contentType) {
    return isEmpty(contentType) ? null : MediaType.valueOf(contentType);
  }

}
