/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.AUXILIAR;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;

import java.util.List;

public class AuxiliarParameter extends BaseParameter {

  private final List<Field> fields;


  public AuxiliarParameter(String externalName, String displayName, ParameterDataType dataType, TypeDefinition typeDefinition,
                           String muleAlias, String description, Boolean required,
                           ResolverExpression<ValueProviderDefinition> valueProvider,
                           String muleMetadataKeyId, String muleTypeResolver,
                           Boolean muleContent, List<Field> fields) {
    super(externalName, displayName, dataType, typeDefinition, muleAlias, description, required, AUXILIAR, muleMetadataKeyId,
          muleTypeResolver, muleContent, valueProvider);
    this.fields = fields;
  }

  public List<Field> getFields() {
    return fields;
  }
}
