/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.weave.v2.grammar.DynamicSelectorOpId$;
import org.mule.weave.v2.grammar.ObjectKeyValueSelectorOpId$;
import org.mule.weave.v2.grammar.ValueSelectorOpId$;
import org.mule.weave.v2.parser.MappingParser;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper;
import org.mule.weave.v2.parser.ast.header.directives.ContentType;
import org.mule.weave.v2.parser.ast.header.directives.OutputDirective;
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.structure.NameNode;
import org.mule.weave.v2.parser.ast.structure.StringNode;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.parser.phase.CompilationPhase;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResource;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class DataWeaveExpressionParser {
    private static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    private static final String DEFAULT_EXPRESSION_POSTFIX = "]";
    private static final String DW_PREFIX = "dw";
    private static final String PREFIX_EXPR_SEPARATOR = ":";
    private static final int DW_PREFIX_LENGTH = "dw:".length();

    public static boolean isBodyBindingUsed(Argument argument) {
        return DataWeaveExpressionParser.isBindingUsed(argument.getValue().getValue(), ParameterType.BODY.getBinding());
    }

    public static boolean isBindingUsed(String script, String variableName) {
        PhaseResult<ParsingResult<DocumentNode>> parse = DataWeaveExpressionParser.parseDWScript(script);
        if (parse.hasResult()) {
            DocumentNode documentNode = (DocumentNode)((ParsingResult)parse.getResult()).astNode();
            Seq binaryOpNodeSeq = AstNodeHelper.collectChildrenWith((AstNode)documentNode, VariableReferenceNode.class);
            Collection binaryOpNodes = JavaConverters.asJavaCollection((Iterable)binaryOpNodeSeq);
            return binaryOpNodes.stream().anyMatch(n -> n.variable().name().equals(variableName));
        }
        return false;
    }

    public static String[] selectionsFromBinding(String script, String variableName) {
        PhaseResult<ParsingResult<DocumentNode>> parse = DataWeaveExpressionParser.parseDWScript(script);
        if (parse.hasResult()) {
            DocumentNode documentNode = (DocumentNode)((ParsingResult)parse.getResult()).astNode();
            Seq binaryOpNodeSeq = AstNodeHelper.collectChildrenWith((AstNode)documentNode, BinaryOpNode.class);
            Collection binaryOpNodes = JavaConverters.asJavaCollection((Iterable)binaryOpNodeSeq);
            return (String[])binaryOpNodes.stream().filter(binaryOpNode -> {
                AstNode lhs;
                boolean isSelector = DataWeaveExpressionParser.isSelectorOperation(binaryOpNode);
                if (isSelector && (binaryOpNode.rhs() instanceof NameNode || binaryOpNode.rhs() instanceof StringNode) && (lhs = binaryOpNode.lhs()) instanceof VariableReferenceNode) {
                    return ((VariableReferenceNode)lhs).variable().name().equals(variableName);
                }
                return false;
            }).map(binaryOpNode -> {
                if (binaryOpNode.rhs() instanceof NameNode) {
                    AstNode astNode = ((NameNode)binaryOpNode.rhs()).keyName();
                    if (astNode instanceof StringNode) {
                        return ((StringNode)astNode).value();
                    }
                } else if (binaryOpNode.rhs() instanceof StringNode) {
                    return ((StringNode)binaryOpNode.rhs()).value();
                }
                throw new IllegalArgumentException("Script: `" + script + "` produced an invalid script. This is a bug.");
            }).toArray(String[]::new);
        }
        return new String[0];
    }

    private static PhaseResult<ParsingResult<DocumentNode>> parseDWScript(String script) {
        String sanitizedScript = DataWeaveExpressionParser.sanitize(script);
        return MappingParser.parse((CompilationPhase)MappingParser.parsingPhase(), (WeaveResource)WeaveResource.anonymous((String)sanitizedScript), (ParsingContext)ParsingContextFactory.createParsingContext());
    }

    private static boolean isSelectorOperation(BinaryOpNode binaryOpNode) {
        return binaryOpNode.opId().equals(ValueSelectorOpId$.MODULE$) || binaryOpNode.opId().equals(DynamicSelectorOpId$.MODULE$) || binaryOpNode.opId().equals(ObjectKeyValueSelectorOpId$.MODULE$);
    }

    private static String sanitize(String expression) {
        String sanitizedExpression;
        if ((expression = expression.trim()).startsWith(DEFAULT_EXPRESSION_PREFIX)) {
            if (!expression.endsWith(DEFAULT_EXPRESSION_POSTFIX)) {
                throw new ExpressionExecutionException(I18nMessageFactory.createStaticMessage((String)String.format("Unbalanced brackets in expression '%s'", expression)));
            }
            sanitizedExpression = expression.substring(DEFAULT_EXPRESSION_PREFIX.length(), expression.length() - DEFAULT_EXPRESSION_POSTFIX.length());
        } else {
            sanitizedExpression = expression;
        }
        if (sanitizedExpression.startsWith("dw:") && !sanitizedExpression.substring(DW_PREFIX_LENGTH, DW_PREFIX_LENGTH + 1).equals(PREFIX_EXPR_SEPARATOR)) {
            sanitizedExpression = sanitizedExpression.substring(DW_PREFIX_LENGTH);
        }
        return sanitizedExpression;
    }

    public static Optional<MediaType> getOutputMediaType(String script) {
        PhaseResult<ParsingResult<DocumentNode>> parse = DataWeaveExpressionParser.parseDWScript(script);
        if (parse.hasResult()) {
            DocumentNode documentNode = (DocumentNode)((ParsingResult)parse.getResult()).astNode();
            Seq outputDirectiveSeq = AstNodeHelper.collectChildrenWith((AstNode)documentNode, OutputDirective.class);
            Collection outputDirectiveNodes = JavaConverters.asJavaCollection((Iterable)outputDirectiveSeq);
            return outputDirectiveNodes.stream().map(outputDirective -> {
                Option mime = outputDirective.mime();
                if (mime.isDefined()) {
                    MediaType mediaType = MediaType.valueOf((String)((ContentType)mime.get()).mime());
                    if (outputDirective.options().isDefined()) {
                        HashMap params = new HashMap();
                        JavaConverters.asJavaCollection((Iterable)((Iterable)outputDirective.options().get())).stream().filter(directiveOption -> directiveOption.value() instanceof StringNode).forEach(directiveOption -> params.put(directiveOption.name().name(), ((StringNode)directiveOption.value()).value()));
                        mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), params);
                    }
                    return mediaType;
                }
                return null;
            }).filter(value -> value != null).findFirst();
        }
        return Optional.empty();
    }
}

