/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiParameterLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2Scheme;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.List;
import java.util.stream.Collectors;

public class ApiSecuritySchemeLoader {
    static void loadSecuritySchemes(APIModel apiModel, ConnectorModelBuilder connectorModelBuilder) {
        List securitySchemes = apiModel.getOperationsModel().stream().flatMap(x -> x.getSecuritySchemesModel().stream()).collect(Collectors.toList());
        for (APISecuritySchemeModel apiSecuritySchemeModel : securitySchemes) {
            SecuritySchemeBuilder securitySchemeBuilder = connectorModelBuilder.getOrCreateSecuritySchemeBuilder(apiSecuritySchemeModel.getName(), ApiSecuritySchemeLoader.getConnectorSecuritySchemeType(apiSecuritySchemeModel.getSecuritySchemeType()));
            ApiSecuritySchemeLoader.loadSecurityScheme(apiSecuritySchemeModel, securitySchemeBuilder);
        }
    }

    private static void loadSecurityScheme(APISecuritySchemeModel apiSecuritySchemeModel, SecuritySchemeBuilder securitySchemeBuilder) {
        if (apiSecuritySchemeModel.getSecuritySchemeType().equals((Object)APISecuritySchemeType.OAUTH2_AUTHORIZATION_CODE)) {
            securitySchemeBuilder.grantType(OAuth2Scheme.GrantType.AUTHORIZATION_CODE);
        } else if (apiSecuritySchemeModel.getSecuritySchemeType().equals((Object)APISecuritySchemeType.OAUTH2_CLIENT_CREDENTIALS)) {
            securitySchemeBuilder.grantType(OAuth2Scheme.GrantType.CLIENT_CREDENTIALS);
        }
        securitySchemeBuilder.accessTokenUri(apiSecuritySchemeModel.getAccessTokenUri());
        securitySchemeBuilder.authorizationUri(apiSecuritySchemeModel.getAuthorizationUri());
        securitySchemeBuilder.scopes(apiSecuritySchemeModel.getScopes());
        ApiParameterLoader.loadSecuritySchemeParameters(apiSecuritySchemeModel.getCustomHeaders(), ParameterType.HEADER, securitySchemeBuilder);
        ApiParameterLoader.loadSecuritySchemeParameters(apiSecuritySchemeModel.getCustomQueryParams(), ParameterType.QUERY, securitySchemeBuilder);
    }

    private static ConnectorSecurityScheme.SecuritySchemeType getConnectorSecuritySchemeType(APISecuritySchemeType apiSecuritySchemeType) {
        switch (apiSecuritySchemeType) {
            case BASIC_AUTH: {
                return ConnectorSecurityScheme.SecuritySchemeType.BASIC;
            }
            case CUSTOM: {
                return ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION;
            }
            case DIGEST: {
                return ConnectorSecurityScheme.SecuritySchemeType.DIGEST_AUTHENTICATION;
            }
            case PASS_THROUGH: {
                return ConnectorSecurityScheme.SecuritySchemeType.PASS_THROUGH;
            }
            case OAUTH2_AUTHORIZATION_CODE: 
            case OAUTH2_CLIENT_CREDENTIALS: {
                return ConnectorSecurityScheme.SecuritySchemeType.OAUTH2;
            }
            case BEARER_AUTH: {
                return ConnectorSecurityScheme.SecuritySchemeType.BEARER;
            }
            case NOT_SUPPORTED: {
                return ConnectorSecurityScheme.SecuritySchemeType.UNSECURED;
            }
        }
        throw new IllegalArgumentException("API Security scheme '" + apiSecuritySchemeType + "' is not supported. This is a bug.");
    }
}

