/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.DwScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.ScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.DataWeaveExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.ScriptDataExpressionDescriptor;
import java.util.List;
import java.util.stream.Collectors;

public class DescriptorDataExpressionLoader {
    static HttpRequestDataExpression loadRequestDataExpression(HttpRequestDataExpressionDescriptor dataExpressionDescriptor) {
        if (dataExpressionDescriptor != null) {
            return new HttpRequestDataExpression(dataExpressionDescriptor.getPath(), HTTPMethod.fromString(dataExpressionDescriptor.getMethod().getName()), dataExpressionDescriptor.getOutputMediaType(), DescriptorDataExpressionLoader.loadHttpRequestBindings(dataExpressionDescriptor.getBindings()));
        }
        return null;
    }

    private static HttpRequestBinding loadHttpRequestBindings(HttpRequestDataExpressionBindingDescriptor bindings) {
        if (bindings != null) {
            return new HttpRequestBinding(DescriptorDataExpressionLoader.loadArguments(bindings.getUriParameters()), DescriptorDataExpressionLoader.loadArguments(bindings.getQueryParameters()), DescriptorDataExpressionLoader.loadArguments(bindings.getHeaders()));
        }
        return null;
    }

    private static List<Argument> loadArguments(List<ArgumentDescriptor> argumentDescriptors) {
        return argumentDescriptors.stream().map(x -> new Argument(x.getName(), new DataWeaveExpression(x.getValue().getExpression()))).collect(Collectors.toList());
    }

    static ScriptDataExpression loadScriptDataExpression(ScriptDataExpressionDescriptor scriptDescriptor) {
        if (scriptDescriptor != null) {
            return new DwScriptDataExpression(scriptDescriptor.getExpression());
        }
        return null;
    }
}

