/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionStatusCodeValidationConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionValidationConfig;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionResponseValidationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionStatusCodeValidationDescriptor;
import java.util.ArrayList;
import java.util.List;

public class DescriptorTestConnectionLoader {
    static TestConnectionConfig loadTestConnection(TestConnectionDescriptor testConnectionDescriptor) {
        if (testConnectionDescriptor == null) {
            return null;
        }
        return new TestConnectionConfig(testConnectionDescriptor.getPath(), DescriptorTestConnectionLoader.loadHttpMethod(testConnectionDescriptor), DescriptorTypeLoader.loadMediaType(testConnectionDescriptor.getMediaType()), DescriptorTestConnectionLoader.buildResponseValidations(testConnectionDescriptor.getResponseValidation()), DescriptorTestConnectionLoader.loadStatusCodeValidation(testConnectionDescriptor.getStatusCodeValidation()));
    }

    private static HTTPMethod loadHttpMethod(TestConnectionDescriptor testConnectionDescriptor) {
        return testConnectionDescriptor.getMethod() == null ? HTTPMethod.GET : HTTPMethod.fromString(testConnectionDescriptor.getMethod());
    }

    private static List<TestConnectionValidationConfig> buildResponseValidations(List<TestConnectionResponseValidationDescriptor> responseValidations) {
        ArrayList<TestConnectionValidationConfig> responseValidationConfigs = new ArrayList<TestConnectionValidationConfig>();
        for (TestConnectionResponseValidationDescriptor responseValidation : responseValidations) {
            responseValidationConfigs.add(new TestConnectionValidationConfig(DescriptorTestConnectionLoader.loadValidationExpression(responseValidation), DescriptorTestConnectionLoader.loadErrorTemplateExpression(responseValidation)));
        }
        return responseValidationConfigs;
    }

    private static TestConnectionStatusCodeValidationConfig loadStatusCodeValidation(TestConnectionStatusCodeValidationDescriptor statusCodeValidationDescriptor) {
        if (statusCodeValidationDescriptor != null) {
            return new TestConnectionStatusCodeValidationConfig(statusCodeValidationDescriptor.getValidStatusCodes() != null ? statusCodeValidationDescriptor.getValidStatusCodes() : null, statusCodeValidationDescriptor.getErrorTemplateExpression() != null ? statusCodeValidationDescriptor.getErrorTemplateExpression().getExpression() : null);
        }
        return null;
    }

    private static String loadErrorTemplateExpression(TestConnectionResponseValidationDescriptor responseValidation) {
        return responseValidation.getErrorTemplateExpression() != null ? responseValidation.getErrorTemplateExpression().getExpression() : null;
    }

    private static String loadValidationExpression(TestConnectionResponseValidationDescriptor responseValidation) {
        return responseValidation.getValidationExpression() != null ? responseValidation.getValidationExpression().getExpression() : null;
    }
}

