/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class DescriptorTypeLoader {
    static void loadDataType(ParameterDescriptor parameterDescriptor, TypeDefinitionBuilder connectorTypeDefinitionBuilder) {
        if (parameterDescriptor.getDataType() == null) {
            return;
        }
        connectorTypeDefinitionBuilder.primitive(DescriptorTypeLoader.loadPrimitiveType(parameterDescriptor.getDataType()));
    }

    static PrimitiveTypeDefinition.PrimitiveType loadPrimitiveType(DataTypeDescriptor dataType) {
        switch (dataType) {
            case STRING: {
                return PrimitiveTypeDefinition.PrimitiveType.STRING;
            }
            case INTEGER: {
                return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
            }
            case LONG: {
                return PrimitiveTypeDefinition.PrimitiveType.LONG;
            }
            case NUMBER: {
                return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
            }
            case ZONED_DATE_TIME: {
                return PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME;
            }
            case LOCAL_DATE_TIME: {
                return PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME;
            }
            case BOOLEAN: {
                return PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
            }
        }
        throw new IllegalArgumentException("Primitive Type not supported. This is a bug.");
    }

    static MediaType loadMediaType(String contentType) {
        return StringUtils.isEmpty((CharSequence)contentType) ? null : MediaType.valueOf((String)contentType);
    }
}

