/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination;

import org.apache.commons.lang3.StringUtils;

public enum PaginationKind {
    OFFSET("offset"),
    PAGE_NUMBER("pageNumber"),
    MARKER("marker"),
    HYPERMEDIA("hypermedia");

    private final String name;

    private PaginationKind(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static PaginationKind forName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (name.equalsIgnoreCase(PaginationKind.OFFSET.name)) {
            return OFFSET;
        }
        if (name.equalsIgnoreCase(PaginationKind.PAGE_NUMBER.name)) {
            return PAGE_NUMBER;
        }
        if (name.equalsIgnoreCase(PaginationKind.MARKER.name)) {
            return MARKER;
        }
        if (name.equalsIgnoreCase(PaginationKind.HYPERMEDIA.name)) {
            return HYPERMEDIA;
        }
        throw new IllegalArgumentException(String.format("Pagination type '%s' is not supported. This is a bug.", name));
    }
}

