/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiParameterLoader.loadOperationParameters;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiTypeLoader.loadInputTypeDefinitions;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiTypeLoader.loadOutputTypeDefinitions;
import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;

public class ApiOperationLoader {

  static void loadOperations(APIModel apiModel, ConnectorModelBuilder connectorModelBuilder) {
    for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
      OperationBuilder connectorOperationBuilder =
          connectorModelBuilder.getOrCreateOperationBuilder(apiOperation.getOperationId(),
                                                            apiOperation.getPath(),
                                                            apiOperation.getHttpMethod(),
                                                            apiOperation.getSummary());
      loadOperation(apiOperation, connectorOperationBuilder);
    }
  }

  private static void loadOperation(APIOperationModel apiOperation,
                                    OperationBuilder connectorOperationBuilder) {
    connectorOperationBuilder
        .displayName(apiOperation.getName())
        .description(apiOperation.getDescription())
        .securitySchemes(
                         apiOperation.getSecuritySchemesModel().stream().map(APISecuritySchemeModel::getName).collect(toList()));

    loadOperationParameters(apiOperation.getUriParamsModel(), connectorOperationBuilder);
    loadOperationParameters(apiOperation.getQueryParamsModel(), connectorOperationBuilder);
    loadOperationParameters(apiOperation.getHeadersModel(), connectorOperationBuilder);

    loadInputTypeDefinitions(apiOperation.getInputMetadataModel(), connectorOperationBuilder);
    loadOutputTypeDefinitions(apiOperation.getOutputMetadataModel(), connectorOperationBuilder);
  }
}
