/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorSampleDataLoader.loadSampleData;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.HEADER;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.QUERY;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.URI;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;

import java.util.List;

public class DescriptorTriggerLoader {

  static void loadTriggers(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorBuilder) {
    if (connectorDescriptor.getTriggers() == null) {
      return;
    }

    for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
      loadTrigger(triggerDescriptor, connectorBuilder.getOrCreateTriggerBuilder(triggerDescriptor.getName()));
    }
  }

  private static void loadTrigger(TriggerDescriptor triggerDescriptor, TriggerBuilder triggerBuilder) {

    triggerBuilder
        .path(triggerDescriptor.getPath())
        .method(triggerDescriptor.getMethod() != null ? HTTPMethod.fromString(triggerDescriptor.getMethod().getName()) : null)
        .itemsExpression(triggerDescriptor.getItemsExpression())
        .outputMediaType(triggerDescriptor.getOutputMediaType())
        .identityExpression(triggerDescriptor.getIdentityExpression())
        .outputTypeSchema(triggerDescriptor.getOutputTypeSchema())
        .displayName(triggerDescriptor.getDisplayName())
        .setDescription(triggerDescriptor.getDescription())
        .ignored(triggerDescriptor.getIgnored())
        .eventExpression(triggerDescriptor.getEventExpression());

    if (triggerDescriptor.getWatermark() != null) {
      triggerBuilder.watermarkExpression(triggerDescriptor.getWatermark().getExtraction());

      if (triggerDescriptor.getWatermark().getDataType() != null) {
        triggerBuilder.watermarkType(ParameterDataType.forName(triggerDescriptor.getWatermark().getDataType().getName()));
      }

    }

    if (triggerDescriptor.getParameterBindings() != null) {
      triggerBuilder.requestBodyExpression(triggerDescriptor.getParameterBindings().getRequestBodyExpression());
      loadParameterBindings(triggerDescriptor.getParameterBindings().getUriParameters(), URI, triggerBuilder);
      loadParameterBindings(triggerDescriptor.getParameterBindings().getQueryParameters(), QUERY, triggerBuilder);
      loadParameterBindings(triggerDescriptor.getParameterBindings().getHeaders(), HEADER, triggerBuilder);
    }

    for (TriggerParameterDescriptor parameterDescriptor : triggerDescriptor.getParameters()) {
      triggerBuilder.getOrCreateParameterBuilder(parameterDescriptor.getName())
          .displayName(parameterDescriptor.getDisplayName())
          .description(parameterDescriptor.getDescription())
          .dataType(ParameterDataType.forName(parameterDescriptor.getDataType().getName()))
          .required(parameterDescriptor.isRequired());
    }

    loadSampleData(triggerDescriptor.getSampleDataExpressionDescriptor(), triggerBuilder.getSampleDataExpressionBuilder());
  }

  private static void loadParameterBindings(List<ParameterBindingDescriptor> parameterBindings,
                                            ParameterType parameterType,
                                            TriggerBuilder triggerBuilder) {

    for (ParameterBindingDescriptor bindingDescriptor : parameterBindings) {
      triggerBuilder
          .getOrCreateParameterBindingBuilder(bindingDescriptor.getName(), parameterType)
          .value(bindingDescriptor.getValue());
    }
  }
}
