/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBindingBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.BodyBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationDisplayNameExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OperationBuilder {
    private final String descriptorIdentifier;
    private final String apiOperationId;
    private final String path;
    private final String method;
    private final String apiSummary;
    private String displayName;
    private String description;
    private final List<ParameterBuilder> uriParameterBuilders = new ArrayList<ParameterBuilder>();
    private final List<ParameterBuilder> queryParameterBuilders = new ArrayList<ParameterBuilder>();
    private final List<ParameterBuilder> headerBuilders = new ArrayList<ParameterBuilder>();
    private final BodyBuilder bodyBuilder = new BodyBuilder();
    private final Map<MediaType, TypeDefinitionBuilder> inputMetadataBuilders = new HashMap<MediaType, TypeDefinitionBuilder>();
    private final Map<MediaType, TypeDefinitionBuilder> outputMetadataBuilders = new HashMap<MediaType, TypeDefinitionBuilder>();
    private List<String> securitySchemeIds;
    private String alternativeBaseUri;
    private String pagination;
    private Boolean skipOutputTypeValidation;
    private Boolean isVoidOperation;
    private QueryParamArrayFormat queryParamArrayFormat;
    private Boolean ignored;
    private SampleDataBuilder sampleDataBuilder = new SampleDataBuilder();
    private MediaType defaultInputMediaType;
    private MediaType defaultOutputMediaType;
    private String forcedOutputTypeSchema;
    private String forcedInputTypeSchema;
    private boolean isAdapter;
    private boolean isSidecar;
    private final List<AuxiliarParameterBuilder> parameters = new ArrayList<AuxiliarParameterBuilder>();
    private final List<AuxiliarParameterBindingBuilder> requestBindings = new ArrayList<AuxiliarParameterBindingBuilder>();
    private final List<AuxiliarParameterBindingBuilder> responseBindings = new ArrayList<AuxiliarParameterBindingBuilder>();

    OperationBuilder(String descriptorIdentifier, OperationBuilder baseOperationBuilder) {
        this.descriptorIdentifier = descriptorIdentifier;
        this.method = baseOperationBuilder.method;
        this.path = baseOperationBuilder.path;
        this.apiSummary = baseOperationBuilder.apiSummary;
        this.apiOperationId = null;
        this.displayName = baseOperationBuilder.displayName;
        this.description = baseOperationBuilder.description;
        this.uriParameterBuilders.addAll(baseOperationBuilder.uriParameterBuilders);
        this.queryParameterBuilders.addAll(baseOperationBuilder.queryParameterBuilders);
        this.headerBuilders.addAll(baseOperationBuilder.headerBuilders);
        this.inputMetadataBuilders.putAll(baseOperationBuilder.inputMetadataBuilders);
        this.outputMetadataBuilders.putAll(baseOperationBuilder.outputMetadataBuilders);
        this.securitySchemeIds(baseOperationBuilder.securitySchemeIds);
        this.alternativeBaseUri = baseOperationBuilder.alternativeBaseUri;
        this.pagination = baseOperationBuilder.pagination;
        this.skipOutputTypeValidation = baseOperationBuilder.skipOutputTypeValidation;
        this.isVoidOperation = baseOperationBuilder.isVoidOperation;
        this.queryParamArrayFormat = baseOperationBuilder.queryParamArrayFormat;
        this.ignored = baseOperationBuilder.ignored;
        this.sampleDataBuilder = new SampleDataBuilder(baseOperationBuilder.sampleDataBuilder);
        this.defaultInputMediaType = baseOperationBuilder.defaultInputMediaType;
        this.defaultOutputMediaType = baseOperationBuilder.defaultOutputMediaType;
        this.forcedOutputTypeSchema = baseOperationBuilder.forcedOutputTypeSchema;
        this.forcedInputTypeSchema = baseOperationBuilder.forcedInputTypeSchema;
        this.isAdapter = baseOperationBuilder.isAdapter;
    }

    OperationBuilder(String apiOperationId, String path, String method, String apiSummary) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(method);
        this.method = method;
        this.path = path;
        this.apiOperationId = apiOperationId;
        this.apiSummary = apiSummary;
        this.descriptorIdentifier = null;
    }

    public OperationBuilder displayName(String displayName) {
        this.displayName = (String)ObjectUtils.defaultIfNull((Object)displayName, (Object)this.displayName);
        return this;
    }

    public OperationBuilder description(String description) {
        this.description = (String)ObjectUtils.defaultIfNull((Object)description, (Object)this.description);
        return this;
    }

    public OperationBuilder securitySchemes(List<String> securitySchemeIds) {
        this.securitySchemeIds = (List)ObjectUtils.defaultIfNull(securitySchemeIds, this.securitySchemeIds);
        return this;
    }

    public OperationBuilder alternativeBaseUri(String alternativeBaseUri) {
        this.alternativeBaseUri = (String)ObjectUtils.defaultIfNull((Object)alternativeBaseUri, (Object)this.alternativeBaseUri);
        return this;
    }

    public boolean hasPagination() {
        return StringUtils.isNotBlank((CharSequence)this.pagination);
    }

    public OperationBuilder pagination(String pagination) {
        this.pagination = (String)ObjectUtils.defaultIfNull((Object)pagination, (Object)this.pagination);
        return this;
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }

    public OperationBuilder skipOutputTypeValidation(Boolean skipOutputTypeValidation) {
        this.skipOutputTypeValidation = (Boolean)ObjectUtils.defaultIfNull((Object)skipOutputTypeValidation, (Object)this.skipOutputTypeValidation);
        return this;
    }

    public Boolean getIsVoidOperation() {
        return this.isVoidOperation;
    }

    public OperationBuilder voidOperation(Boolean isVoidOperation) {
        this.isVoidOperation = (Boolean)ObjectUtils.defaultIfNull((Object)isVoidOperation, (Object)this.isVoidOperation);
        return this;
    }

    public Boolean isIgnored() {
        return this.ignored;
    }

    public OperationBuilder ignored(Boolean ignored) {
        this.ignored = (Boolean)ObjectUtils.defaultIfNull((Object)ignored, (Object)this.ignored);
        return this;
    }

    public OperationBuilder queryParamArrayFormat(QueryParamArrayFormat queryParamArrayFormat) {
        this.queryParamArrayFormat = (QueryParamArrayFormat)((Object)ObjectUtils.defaultIfNull((Object)((Object)queryParamArrayFormat), (Object)((Object)this.queryParamArrayFormat)));
        return this;
    }

    public MediaType getDefaultInputMediaType() {
        return this.defaultInputMediaType;
    }

    public OperationBuilder setDefaultInputMediaType(MediaType defaultInputMediaType) {
        this.defaultInputMediaType = (MediaType)ObjectUtils.defaultIfNull((Object)defaultInputMediaType, (Object)this.defaultInputMediaType);
        return this;
    }

    public MediaType getDefaultOutputMediaType() {
        return this.defaultOutputMediaType;
    }

    public OperationBuilder setDefaultOutputMediaType(MediaType defaultOutputMediaType) {
        this.defaultOutputMediaType = (MediaType)ObjectUtils.defaultIfNull((Object)defaultOutputMediaType, (Object)this.defaultOutputMediaType);
        return this;
    }

    public OperationBuilder parameters(List<AuxiliarParameterBuilder> parameters) {
        this.parameters.clear();
        this.parameters.addAll(parameters);
        return this;
    }

    public OperationBuilder requestBindings(List<AuxiliarParameterBindingBuilder> requestBindings) {
        this.requestBindings.clear();
        if (requestBindings != null) {
            this.requestBindings.addAll(requestBindings);
        }
        return this;
    }

    public OperationBuilder responseBindings(List<AuxiliarParameterBindingBuilder> responseBindings) {
        this.responseBindings.clear();
        if (responseBindings != null) {
            this.responseBindings.addAll(responseBindings);
        }
        return this;
    }

    public OperationBuilder uriParameters(List<ParameterBuilder> uriParameters) {
        this.uriParameterBuilders.clear();
        if (uriParameters != null) {
            this.uriParameterBuilders.addAll(uriParameters);
        }
        return this;
    }

    public OperationBuilder queryParameters(List<ParameterBuilder> queryParameterBuilders) {
        this.queryParameterBuilders.clear();
        if (queryParameterBuilders != null) {
            this.queryParameterBuilders.addAll(queryParameterBuilders);
        }
        return this;
    }

    public OperationBuilder headers(List<ParameterBuilder> headerBuilders) {
        this.headerBuilders.clear();
        if (headerBuilders != null) {
            this.headerBuilders.addAll(headerBuilders);
        }
        return this;
    }

    public OperationBuilder securitySchemeIds(List<String> securitySchemeIds) {
        if (this.securitySchemeIds == null) {
            this.securitySchemeIds = new ArrayList<String>();
        } else {
            this.securitySchemeIds.clear();
        }
        this.securitySchemeIds.addAll(securitySchemeIds);
        return this;
    }

    public OperationBuilder adapter() {
        this.isAdapter = true;
        return this;
    }

    public OperationBuilder sidecar() {
        this.isSidecar = true;
        return this;
    }

    public String getDescriptorIdentifier() {
        return this.descriptorIdentifier;
    }

    public String getPath() {
        return this.path;
    }

    public String getApiOperationId() {
        return this.apiOperationId;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isAdapter() {
        return this.isAdapter;
    }

    public boolean hasForcedOutputTypeSchema() {
        return this.forcedOutputTypeSchema != null;
    }

    public OperationBuilder forceOutputTypeSchema(String forcedOutputTypeSchema) {
        this.forcedOutputTypeSchema = (String)ObjectUtils.defaultIfNull((Object)forcedOutputTypeSchema, (Object)this.forcedOutputTypeSchema);
        return this;
    }

    public boolean hasForcedInputTypeSchema() {
        return this.forcedInputTypeSchema != null;
    }

    public OperationBuilder forceInputTypeSchema(String forcedInputTypeSchema) {
        this.forcedInputTypeSchema = (String)ObjectUtils.defaultIfNull((Object)forcedInputTypeSchema, (Object)this.forcedInputTypeSchema);
        return this;
    }

    public List<TypeDefinitionBuilder> getMultipartInputMetadataBuilders() {
        return this.inputMetadataBuilders.values().stream().filter(TypeDefinitionBuilder::isMultipart).collect(Collectors.toList());
    }

    public Map<MediaType, TypeDefinitionBuilder> getInputMetadataBuilders() {
        return this.inputMetadataBuilders;
    }

    public TypeDefinitionBuilder getOrCreateInputMetadataBuilder(MediaType mediaType) {
        return this.getOrCreateTypeDefinitionBuilder(this.inputMetadataBuilders, mediaType);
    }

    public Map<MediaType, TypeDefinitionBuilder> getOutputMetadataBuilders() {
        return this.outputMetadataBuilders;
    }

    public TypeDefinitionBuilder getOrCreateOutputMetadataBuilder(MediaType mediaType) {
        return this.getOrCreateTypeDefinitionBuilder(this.outputMetadataBuilders, mediaType);
    }

    private TypeDefinitionBuilder getOrCreateTypeDefinitionBuilder(Map<MediaType, TypeDefinitionBuilder> map, MediaType mediaType) {
        TypeDefinitionBuilder typeDefinitionBuilder = map.get(mediaType);
        if (typeDefinitionBuilder == null) {
            typeDefinitionBuilder = new TypeDefinitionBuilder();
            map.put(mediaType, typeDefinitionBuilder);
        }
        return typeDefinitionBuilder;
    }

    public ParameterBuilder getOrCreateParameterBuilder(ParameterType parameterType, String externalName) {
        List<ParameterBuilder> parameterBuilders = this.getParameterBuilders(parameterType);
        ParameterBuilder paramBuilder = parameterBuilders.stream().filter(x -> x.getExternalName().equalsIgnoreCase(externalName)).findFirst().orElse(null);
        if (paramBuilder == null) {
            paramBuilder = new ParameterBuilder(parameterType, externalName);
            parameterBuilders.add(paramBuilder);
        }
        return paramBuilder;
    }

    private List<ParameterBuilder> getParameterBuilders(ParameterType parameterType) {
        switch (parameterType) {
            case URI: {
                return this.uriParameterBuilders;
            }
            case QUERY: {
                return this.queryParameterBuilders;
            }
            case HEADER: {
                return this.headerBuilders;
            }
        }
        throw new IllegalArgumentException("Parameter Type not supported");
    }

    public SampleDataBuilder getSampleDataBuilder() {
        return this.sampleDataBuilder;
    }

    ConnectorOperation build(OperationIdentifierExpressionHandler identifierHandler, OperationDisplayNameExpressionHandler displayNameHandler, TypeSchemaPool typeSchemaPool, List<Pagination> paginations, List<ConnectorSecurityScheme> securitySchemes, MediaType globalDefaultInputMediaType, MediaType globalDefaultOutputMediaType, QueryParamArrayFormat globalQueryParamArrayFormat, Boolean globalSkipOutputTypeValidation) {
        Pagination pagination = this.pagination != null ? paginations.stream().filter(x -> x.getName().equals(this.pagination)).findFirst().orElseThrow(() -> new IllegalArgumentException("Pagination not found. This is a bug.")) : null;
        ArrayList<String> collisionParameterNames = new ArrayList<String>();
        ConnectorOperation operation = new ConnectorOperation(this.descriptorIdentifier != null ? this.descriptorIdentifier : identifierHandler.evaluate(this.apiOperationId, this.method, this.path), this.displayName != null ? this.displayName : displayNameHandler.evaluate(this.apiOperationId, this.method, this.path, this.apiSummary), this.description, this.path, HTTPMethod.fromString(this.method), this.buildParameters(this.uriParameterBuilders, typeSchemaPool, collisionParameterNames), this.buildParameters(this.queryParameterBuilders, typeSchemaPool, collisionParameterNames), this.buildHeaders(this.headerBuilders, typeSchemaPool, collisionParameterNames), this.buildAuxiliarParameters(this.parameters, typeSchemaPool, collisionParameterNames), this.buildParameterBindings(this.requestBindings), this.buildParameterBindings(this.responseBindings), this.bodyBuilder.buildBody(), this.buildIOType(this.inputMetadataBuilders, this.forcedInputTypeSchema, (MediaType)ObjectUtils.defaultIfNull((Object)this.defaultInputMediaType, (Object)globalDefaultInputMediaType), typeSchemaPool), this.buildIOType(this.outputMetadataBuilders, this.forcedOutputTypeSchema, (MediaType)ObjectUtils.defaultIfNull((Object)this.defaultOutputMediaType, (Object)globalDefaultOutputMediaType), typeSchemaPool), this.buildSecuritySchemes(securitySchemes), this.alternativeBaseUri, pagination, (Boolean)ObjectUtils.defaultIfNull((Object)this.skipOutputTypeValidation, (Object)globalSkipOutputTypeValidation), this.isVoidOperation, this.buildQueryParamArrayFormat(globalQueryParamArrayFormat), this.ignored != null && this.ignored != false, this.isAdapter, this.isSidecar);
        operation.setSampleData(this.sampleDataBuilder.build(operation));
        return operation;
    }

    private List<ParameterBinding> buildParameterBindings(List<AuxiliarParameterBindingBuilder> bindings) {
        return bindings.stream().map(AuxiliarParameterBindingBuilder::build).collect(Collectors.toList());
    }

    public BodyBuilder getBodyBuilder() {
        return this.bodyBuilder;
    }

    private List<ConnectorSecurityScheme> buildSecuritySchemes(List<ConnectorSecurityScheme> securitySchemes) {
        if (this.securitySchemeIds == null || this.securitySchemeIds.isEmpty()) {
            return securitySchemes.stream().filter(x -> x.getName().equalsIgnoreCase(ConnectorSecurityScheme.SecuritySchemeType.UNSECURED.toString())).collect(Collectors.toList());
        }
        return securitySchemes.stream().filter(x -> this.securitySchemeIds.contains(x.getName())).collect(Collectors.toList());
    }

    private QueryParamArrayFormat buildQueryParamArrayFormat(QueryParamArrayFormat globalQueryParamArrayFormat) {
        return (QueryParamArrayFormat)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.queryParamArrayFormat), (Object)((Object)globalQueryParamArrayFormat)));
    }

    private TypeDefinition buildIOType(Map<MediaType, TypeDefinitionBuilder> builders, String forcedTypeSchema, MediaType defaultMediaType, TypeSchemaPool typeSchemaPool) {
        TypeDefinitionBuilder typeBuilder = this.getTypeDefinitionBuilderForMediaTypeOrDefault(builders, defaultMediaType);
        if (typeBuilder != null) {
            return typeBuilder.build(typeSchemaPool, forcedTypeSchema);
        }
        if (forcedTypeSchema != null) {
            return new TypeDefinitionBuilder().object().build(typeSchemaPool, forcedTypeSchema);
        }
        return null;
    }

    private List<Parameter> buildHeaders(List<ParameterBuilder> headerBuilders, TypeSchemaPool typeSchemaPool, List<String> collisionParameterNames) {
        return this.buildParameters(headerBuilders.stream().filter(x -> !x.getExternalName().equalsIgnoreCase("accept")).collect(Collectors.toList()), typeSchemaPool, collisionParameterNames);
    }

    private List<Parameter> buildParameters(List<ParameterBuilder> parameterBuilders, TypeSchemaPool typeSchemaPool, List<String> collisionParameterNames) {
        return parameterBuilders.stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(x -> x.buildParameter(typeSchemaPool, collisionParameterNames)).collect(Collectors.toList());
    }

    private List<AuxiliarParameter> buildAuxiliarParameters(List<AuxiliarParameterBuilder> parameterBuilders, TypeSchemaPool typeSchemaPool, List<String> collisionParameterNames) {
        return parameterBuilders.stream().map(x -> x.build(typeSchemaPool, collisionParameterNames)).collect(Collectors.toList());
    }

    private TypeDefinitionBuilder getTypeDefinitionBuilderForMediaTypeOrDefault(Map<MediaType, TypeDefinitionBuilder> builders, MediaType mediaType) {
        if (builders == null || builders.isEmpty()) {
            return null;
        }
        if (mediaType == null) {
            return this.getDefaultTypeDefinitionBuilder(builders);
        }
        TypeDefinitionBuilder typeDefinitionBuilder = builders.get(mediaType);
        if (typeDefinitionBuilder != null) {
            return typeDefinitionBuilder;
        }
        return this.getDefaultTypeDefinitionBuilder(builders);
    }

    private TypeDefinitionBuilder getDefaultTypeDefinitionBuilder(Map<MediaType, TypeDefinitionBuilder> builders) {
        if (builders.get(MediaType.APPLICATION_JSON_TYPE) != null) {
            return builders.get(MediaType.APPLICATION_JSON_TYPE);
        }
        if (builders.get(MediaType.APPLICATION_XML_TYPE) != null) {
            return builders.get(MediaType.APPLICATION_XML_TYPE);
        }
        return builders.values().stream().findFirst().orElse(null);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ParameterBuilder> getUriParameters() {
        return this.uriParameterBuilders;
    }

    public List<ParameterBuilder> getQueryParameters() {
        return this.queryParameterBuilders;
    }

    public List<ParameterBuilder> getHeaders() {
        return this.headerBuilders;
    }

    public Map<MediaType, TypeDefinitionBuilder> getInputMetadata() {
        return this.inputMetadataBuilders;
    }

    public HTTPMethod getHttpMethod() {
        return HTTPMethod.fromString(this.method);
    }
}

