/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorSampleDataLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import java.util.List;

public class DescriptorTriggerLoader {
    static void loadTriggers(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorBuilder) {
        if (connectorDescriptor.getTriggers() == null) {
            return;
        }
        for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
            DescriptorTriggerLoader.loadTrigger(triggerDescriptor, connectorBuilder.getOrCreateTriggerBuilder(triggerDescriptor.getName()));
        }
    }

    private static void loadTrigger(TriggerDescriptor triggerDescriptor, TriggerBuilder triggerBuilder) {
        triggerBuilder.path(triggerDescriptor.getPath()).method(triggerDescriptor.getMethod() != null ? HTTPMethod.fromString(triggerDescriptor.getMethod().getName()) : null).itemsExpression(triggerDescriptor.getItemsExpression()).outputMediaType(triggerDescriptor.getOutputMediaType()).identityExpression(triggerDescriptor.getIdentityExpression()).outputTypeSchema(triggerDescriptor.getOutputTypeSchema()).displayName(triggerDescriptor.getDisplayName()).setDescription(triggerDescriptor.getDescription()).ignored(triggerDescriptor.getIgnored()).eventExpression(triggerDescriptor.getEventExpression());
        if (triggerDescriptor.getWatermark() != null) {
            triggerBuilder.watermarkExpression(triggerDescriptor.getWatermark().getExtraction());
            if (triggerDescriptor.getWatermark().getDataType() != null) {
                triggerBuilder.watermarkType(ParameterDataType.forName(triggerDescriptor.getWatermark().getDataType().getName()));
            }
        }
        if (triggerDescriptor.getParameterBindings() != null) {
            triggerBuilder.requestBodyExpression(triggerDescriptor.getParameterBindings().getRequestBodyExpression());
            DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getUriParameters(), ParameterType.URI, triggerBuilder);
            DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getQueryParameters(), ParameterType.QUERY, triggerBuilder);
            DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getHeaders(), ParameterType.HEADER, triggerBuilder);
        }
        for (TriggerParameterDescriptor parameterDescriptor : triggerDescriptor.getParameters()) {
            triggerBuilder.getOrCreateParameterBuilder(parameterDescriptor.getName()).displayName(parameterDescriptor.getDisplayName()).description(parameterDescriptor.getDescription()).dataType(ParameterDataType.forName(parameterDescriptor.getDataType().getName())).required(parameterDescriptor.isRequired());
        }
        DescriptorSampleDataLoader.loadSampleData((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)triggerDescriptor.getSampleDataExpressionDescriptor(), triggerBuilder.getSampleDataExpressionBuilder());
    }

    private static void loadParameterBindings(List<ParameterBindingDescriptor> parameterBindings, ParameterType parameterType, TriggerBuilder triggerBuilder) {
        for (ParameterBindingDescriptor bindingDescriptor : parameterBindings) {
            triggerBuilder.getOrCreateParameterBindingBuilder(bindingDescriptor.getName(), parameterType).value(bindingDescriptor.getValue());
        }
    }
}

