/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BaseParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import java.util.List;

public class Parameter
extends BaseParameter {
    private final String defaultValue;
    private final boolean isPassword;
    private final ResolverExpression<ValueProviderDefinition> valueProvider;
    private final List<Field> fields;

    public Parameter(String displayName, String externalName, ParameterType parameterType, TypeDefinition typeDefinition, String description, boolean required, String defaultValue, boolean password, ResolverExpression<ValueProviderDefinition> valueProvider, List<String> collisionInternalNames, List<Field> fields) {
        this(NamingUtil.buildParameterInternalName(externalName, collisionInternalNames, parameterType), displayName, externalName, parameterType, typeDefinition, description, required, defaultValue, password, valueProvider, fields);
    }

    protected Parameter(String internalName, String displayName, String externalName, ParameterType parameterType, TypeDefinition typeDefinition, String description, boolean required, String defaultValue, boolean password, ResolverExpression<ValueProviderDefinition> valueProvider, List<Field> fields) {
        super(externalName, internalName, displayName, ParameterDataType.STRING, typeDefinition, description, required, parameterType);
        this.isPassword = password;
        this.defaultValue = defaultValue;
        this.valueProvider = valueProvider;
        this.fields = fields;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public ResolverExpression<ValueProviderDefinition> getValueProvider() {
        return this.valueProvider;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public int hashCode() {
        return HashCodeUtil.generateHashCode(this.internalName, this.displayName, this.description, this.required, this.defaultValue, this.typeDefinition, this.isPassword);
    }
}

