/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder;

public class FieldBuilder {

  private final String name;
  private final ValueProviderBuilder valueProviderExpressionBuilder = new ValueProviderBuilder();

  public FieldBuilder(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public ValueProviderBuilder getValueProviderBuilder() {
    return this.valueProviderExpressionBuilder;
  }

  public Field buildField() {
    return new Field(name, valueProviderExpressionBuilder.build());
  }

}
