/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class NamingUtil {
    private static final Pattern CHARACTER_SPLIT_PATTERN = Pattern.compile("([a-zA-Z0-9])([\\-_.]+)([a-zA-Z0-9]*)");

    private NamingUtil() {
    }

    public static boolean isFriendlyName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        if (name.contains(" ")) {
            return true;
        }
        return ParserUtils.splitCaps((String)name, (String)" ").equalsIgnoreCase(name) && !CHARACTER_SPLIT_PATTERN.matcher(name).find();
    }

    public static String makeNameFriendly(String name) {
        String friendlyName = name.trim();
        if (friendlyName.contains(" ")) {
            return friendlyName;
        }
        while (CHARACTER_SPLIT_PATTERN.matcher(friendlyName).find()) {
            friendlyName = CHARACTER_SPLIT_PATTERN.matcher(friendlyName).replaceAll("$1 $3");
        }
        if ((friendlyName = ParserUtils.splitCaps((String)friendlyName, (String)" ")).toUpperCase().equals(friendlyName)) {
            friendlyName = friendlyName.toLowerCase();
        }
        return StringUtils.capitalize((String)friendlyName);
    }
}

