/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;


public enum Protocol {

  HTTP("http"), HTTPS("https");

  private final String scheme;

  Protocol(String scheme) {
    this.scheme = scheme;
  }

  public static Protocol getFromString(String scheme) {
    if (HTTP.scheme.equalsIgnoreCase(scheme)) {
      return HTTP;
    }
    if (HTTPS.scheme.equalsIgnoreCase(scheme)) {
      return HTTPS;
    }

    throw new IllegalArgumentException("Protocol " + scheme + " is not supported. (Valid values are HTTP and HTTPS)");
  }

  @Override
  public String toString() {
    return scheme;
  }
}
