/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils.splitCaps;
import static java.util.regex.Pattern.compile;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.isBlank;

import java.util.regex.Pattern;

public final class NamingUtil {

  private NamingUtil() {}

  private static final Pattern CHARACTER_SPLIT_PATTERN = compile("([a-zA-Z0-9])([\\-_.]+)([a-zA-Z0-9]*)");

  public static boolean isFriendlyName(String name) {
    if (isBlank(name)) {
      return false;
    }

    if (name.contains(" ")) {
      return true;
    }

    return splitCaps(name, " ").equalsIgnoreCase(name)
        && !CHARACTER_SPLIT_PATTERN.matcher(name).find();
  }

  public static String makeNameFriendly(String name) {
    String friendlyName = name.trim();

    if (friendlyName.contains(" ")) {
      return friendlyName;
    }

    while (CHARACTER_SPLIT_PATTERN.matcher(friendlyName).find()) {
      friendlyName = CHARACTER_SPLIT_PATTERN.matcher(friendlyName).replaceAll("$1 $3");
    }

    friendlyName = splitCaps(friendlyName, " ");

    if (friendlyName.toUpperCase().equals(friendlyName)) {
      friendlyName = friendlyName.toLowerCase();
    }

    return capitalize(friendlyName);
  }
}
