/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ParameterIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BasicAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BearerAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.DigestAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2Scheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.PassThroughScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.UnsecuredScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.ComparisonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class SecuritySchemeBuilder {
    private final ConnectorSecurityScheme.SecuritySchemeType type;
    private final String name;
    private final List<ParameterBuilder> nonStandardHeaderBuilders = new ArrayList<ParameterBuilder>();
    private final List<ParameterBuilder> nonStandardQueryParameterBuilders = new ArrayList<ParameterBuilder>();
    private TestConnectionConfig testConnectionConfig;
    private String authorizationUri;
    private String accessTokenUri;
    private List<String> scopes;
    private String refreshTokenConditionExpression;
    private OAuth2Scheme.GrantType grantType;
    private Boolean ignored;

    public SecuritySchemeBuilder(String name, ConnectorSecurityScheme.SecuritySchemeType type) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ConnectorSecurityScheme.SecuritySchemeType getType() {
        return this.type;
    }

    public Boolean isIgnored() {
        return this.ignored;
    }

    public ParameterBuilder getOrCreateParameterBuilder(ParameterType parameterType, String name) {
        List<ParameterBuilder> parameterBuilders = this.getParameterBuilders(parameterType);
        ParameterBuilder paramBuilder = parameterBuilders.stream().filter(x -> ComparisonUtil.externalNameParamsComparison(x.getExternalName(), name, parameterType)).findFirst().orElse(null);
        if (paramBuilder == null) {
            String parameterIdentifier = null;
            paramBuilder = new ParameterBuilder(parameterType, name, parameterIdentifier);
            parameterBuilders.add(paramBuilder);
        }
        return paramBuilder;
    }

    private List<ParameterBuilder> getParameterBuilders(ParameterType parameterType) {
        switch (parameterType) {
            case QUERY: {
                return this.nonStandardQueryParameterBuilders;
            }
            case HEADER: {
                return this.nonStandardHeaderBuilders;
            }
        }
        throw new IllegalArgumentException("Parameter Type not supported");
    }

    public SecuritySchemeBuilder testConnectionConfig(TestConnectionConfig testConnectionConfig) {
        this.testConnectionConfig = (TestConnectionConfig)ObjectUtils.defaultIfNull((Object)testConnectionConfig, (Object)this.testConnectionConfig);
        return this;
    }

    public SecuritySchemeBuilder authorizationUri(String authorizationUri) {
        this.authorizationUri = (String)ObjectUtils.defaultIfNull((Object)authorizationUri, (Object)this.authorizationUri);
        return this;
    }

    public SecuritySchemeBuilder accessTokenUri(String accessTokenUri) {
        this.accessTokenUri = (String)ObjectUtils.defaultIfNull((Object)accessTokenUri, (Object)this.accessTokenUri);
        return this;
    }

    public SecuritySchemeBuilder scopes(List<String> scopes) {
        this.scopes = (List)ObjectUtils.defaultIfNull(scopes, this.scopes);
        return this;
    }

    public SecuritySchemeBuilder refreshTokenConditionExpression(String refreshTokenConditionExpression) {
        this.refreshTokenConditionExpression = (String)ObjectUtils.defaultIfNull((Object)refreshTokenConditionExpression, (Object)this.refreshTokenConditionExpression);
        return this;
    }

    public SecuritySchemeBuilder grantType(OAuth2Scheme.GrantType grantType) {
        this.grantType = (OAuth2Scheme.GrantType)((Object)ObjectUtils.defaultIfNull((Object)((Object)grantType), (Object)((Object)this.grantType)));
        return this;
    }

    public SecuritySchemeBuilder ignored(Boolean ignored) {
        this.ignored = (Boolean)ObjectUtils.defaultIfNull((Object)ignored, (Object)this.ignored);
        return this;
    }

    public ConnectorSecurityScheme build(TypeSchemaPool typeSchemaPool, TestConnectionConfig defaultTestConnectionConfig, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler) {
        TestConnectionConfig testConnectionConfig = (TestConnectionConfig)ObjectUtils.defaultIfNull((Object)this.testConnectionConfig, (Object)defaultTestConnectionConfig);
        switch (this.type) {
            case BASIC: {
                return this.buildBasicAuthScheme(testConnectionConfig);
            }
            case CUSTOM_AUTHENTICATION: {
                return this.buildCustomAuthenticationScheme(typeSchemaPool, parameterIdentifierExpressionHandler, testConnectionConfig);
            }
            case DIGEST_AUTHENTICATION: {
                return this.buildDigestAuthenticationSchemeScheme(testConnectionConfig);
            }
            case PASS_THROUGH: {
                return this.buildPassThroughScheme(typeSchemaPool, parameterIdentifierExpressionHandler, testConnectionConfig);
            }
            case OAUTH2: {
                return this.buildOauth2Scheme(typeSchemaPool, parameterIdentifierExpressionHandler, testConnectionConfig);
            }
            case BEARER: {
                return this.buildBearerAuthScheme(testConnectionConfig);
            }
            case UNSECURED: 
            case NOT_SUPPORTED: {
                return this.buildUnsecuredScheme(testConnectionConfig);
            }
        }
        throw new IllegalArgumentException("Security scheme '" + (Object)((Object)this.type) + "' is not supported.");
    }

    private ConnectorSecurityScheme buildOauth2Scheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler, TestConnectionConfig testConnectionConfig) {
        Objects.requireNonNull(this.grantType);
        if (this.grantType.equals((Object)OAuth2Scheme.GrantType.AUTHORIZATION_CODE)) {
            return this.buildOAuth2AuthorizationCodeScheme(typeSchemaPool, parameterIdentifierExpressionHandler, testConnectionConfig);
        }
        if (this.grantType.equals((Object)OAuth2Scheme.GrantType.CLIENT_CREDENTIALS)) {
            return this.buildOAuth2ClientCredentialsScheme(typeSchemaPool, parameterIdentifierExpressionHandler, testConnectionConfig);
        }
        throw new IllegalArgumentException("Grant type not supported. This is a bug.");
    }

    private BasicAuthScheme buildBasicAuthScheme(TestConnectionConfig testConnectionConfig) {
        return new BasicAuthScheme(this.name, testConnectionConfig);
    }

    private CustomAuthenticationScheme buildCustomAuthenticationScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new CustomAuthenticationScheme(this.name, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdentifierExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdentifierExpressionHandler), testConnectionConfig);
    }

    private DigestAuthenticationScheme buildDigestAuthenticationSchemeScheme(TestConnectionConfig testConnectionConfig) {
        return new DigestAuthenticationScheme(this.name, testConnectionConfig);
    }

    private OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new OAuth2AuthorizationCodeScheme(this.name, this.authorizationUri, this.accessTokenUri, this.scopes, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdentifierExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdentifierExpressionHandler), testConnectionConfig, this.refreshTokenConditionExpression);
    }

    private OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new OAuth2ClientCredentialsScheme(this.name, this.authorizationUri, this.accessTokenUri, this.scopes, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdentifierExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdentifierExpressionHandler), testConnectionConfig, this.refreshTokenConditionExpression);
    }

    private PassThroughScheme buildPassThroughScheme(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler, TestConnectionConfig testConnectionConfig) {
        return new PassThroughScheme(this.name, this.buildNonStandardQueryParameters(typeSchemaPool, parameterIdentifierExpressionHandler), this.buildNonStandardHeaders(typeSchemaPool, parameterIdentifierExpressionHandler), testConnectionConfig);
    }

    private UnsecuredScheme buildUnsecuredScheme(TestConnectionConfig testConnectionConfig) {
        return new UnsecuredScheme(testConnectionConfig);
    }

    private BearerAuthScheme buildBearerAuthScheme(TestConnectionConfig testConnectionConfig) {
        return new BearerAuthScheme(this.name, testConnectionConfig);
    }

    private List<Parameter> buildNonStandardQueryParameters(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler) {
        return this.nonStandardQueryParameterBuilders.stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(x -> x.buildParameter(typeSchemaPool, parameterIdentifierExpressionHandler)).collect(Collectors.toList());
    }

    private List<Parameter> buildNonStandardHeaders(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler) {
        return this.nonStandardHeaderBuilders.stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(x -> x.buildParameter(typeSchemaPool, parameterIdentifierExpressionHandler)).collect(Collectors.toList());
    }
}

