/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeSchemaBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ArrayTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ObjectTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.UnionTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TypeDefinitionBuilder {
    private Class<?> classToBuild;
    private TypeDefinitionBuilder innerType;
    private List<ParameterBuilder> parts;
    private PrimitiveTypeDefinition.PrimitiveType primitiveType;
    private List<TypeDefinitionBuilder> unionTypes;
    private MediaType mediaType;
    private String example;
    private List<String> enumValues;
    private String displayName;
    private String description;
    private Supplier<String> rawSchemaSupplier;
    private String schemaPath;
    private String elementName;

    public TypeDefinitionBuilder primitive(PrimitiveTypeDefinition.PrimitiveType primitiveType) {
        Objects.requireNonNull(primitiveType);
        this.classToBuild = PrimitiveTypeDefinition.class;
        this.primitiveType = primitiveType;
        return this;
    }

    public TypeDefinitionBuilder array(TypeDefinitionBuilder innerType) {
        Objects.requireNonNull(innerType);
        this.classToBuild = ArrayTypeDefinition.class;
        this.innerType = innerType;
        return this;
    }

    public TypeDefinitionBuilder multipart(List<ParameterBuilder> parts) {
        Objects.requireNonNull(parts);
        this.classToBuild = MultipartTypeDefinition.class;
        this.parts = parts;
        return this;
    }

    public ParameterBuilder getPartParameter(String externalName) {
        return this.parts.stream().filter(x -> x.getExternalName().equals(externalName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Specified part parameter does not exist. This is a bug."));
    }

    public List<ParameterBuilder> getParts() {
        return this.parts;
    }

    public TypeDefinitionBuilder object() {
        this.classToBuild = ObjectTypeDefinition.class;
        return this;
    }

    public TypeDefinitionBuilder union(List<TypeDefinitionBuilder> unionTypes) {
        Objects.requireNonNull(unionTypes);
        this.classToBuild = UnionTypeDefinition.class;
        this.unionTypes = unionTypes;
        return this;
    }

    public TypeDefinitionBuilder empty() {
        this.classToBuild = EmptyTypeDefinition.class;
        return this;
    }

    public boolean isEmpty() {
        return this.classToBuild == EmptyTypeDefinition.class;
    }

    public TypeDefinitionBuilder displayName(String displayName) {
        this.displayName = (String)ObjectUtils.defaultIfNull((Object)displayName, (Object)this.displayName);
        return this;
    }

    public TypeDefinitionBuilder description(String description) {
        this.description = (String)ObjectUtils.defaultIfNull((Object)description, (Object)this.description);
        return this;
    }

    public TypeDefinitionBuilder mediaType(MediaType mediaType) {
        this.mediaType = (MediaType)ObjectUtils.defaultIfNull((Object)mediaType, (Object)this.mediaType);
        return this;
    }

    public TypeDefinitionBuilder typeSchema(Supplier<String> rawSchema) {
        this.rawSchemaSupplier = (Supplier)ObjectUtils.defaultIfNull(rawSchema, this.rawSchemaSupplier);
        return this;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Supplier<String> getRawSchemaSupplier() {
        return this.rawSchemaSupplier;
    }

    public TypeDefinitionBuilder enumValues(List<String> enumValues) {
        this.enumValues = (List)ObjectUtils.defaultIfNull(enumValues, this.enumValues);
        return this;
    }

    public TypeDefinitionBuilder example(String example) {
        this.example = (String)ObjectUtils.defaultIfNull((Object)example, (Object)this.example);
        return this;
    }

    public TypeDefinitionBuilder schemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
        return this;
    }

    public TypeDefinitionBuilder elementName(String elementName) {
        this.elementName = elementName;
        return this;
    }

    public boolean canBuild() {
        return this.classToBuild != null;
    }

    public boolean isMultipart() {
        return this.classToBuild == MultipartTypeDefinition.class;
    }

    public TypeDefinition build(TypeSchemaPool typeSchemaPool, String forcedSchema) {
        Objects.requireNonNull(this.classToBuild, "Must select a type. This is a bug.");
        TypeSchema typeSchema = this.buildTypeSchema(typeSchemaPool, forcedSchema);
        MediaType mediaType = this.buildMediaType(typeSchema);
        if (this.classToBuild.equals(ObjectTypeDefinition.class) || StringUtils.isNotBlank((CharSequence)forcedSchema)) {
            return new ObjectTypeDefinition(mediaType, this.example, this.enumValues, typeSchema, this.displayName, this.description);
        }
        if (this.classToBuild.equals(ArrayTypeDefinition.class)) {
            return new ArrayTypeDefinition(mediaType, this.example, this.enumValues, typeSchema, this.innerType.mediaType(mediaType).build(typeSchemaPool, null), this.displayName, this.description);
        }
        if (this.classToBuild.equals(MultipartTypeDefinition.class)) {
            return new MultipartTypeDefinition(this.example, this.enumValues, typeSchema, this.parts.stream().map(x -> x.buildPartParameter(typeSchemaPool)).collect(Collectors.toList()), this.displayName, this.description);
        }
        if (this.classToBuild.equals(PrimitiveTypeDefinition.class)) {
            return new PrimitiveTypeDefinition(mediaType, this.example, this.enumValues, typeSchema, this.primitiveType, this.displayName, this.description);
        }
        if (this.classToBuild.equals(UnionTypeDefinition.class)) {
            return new UnionTypeDefinition(mediaType, this.example, this.enumValues, typeSchema, this.unionTypes.stream().map(x -> x.build(typeSchemaPool, null)).collect(Collectors.toList()), this.displayName, this.description);
        }
        if (this.classToBuild.equals(EmptyTypeDefinition.class)) {
            return new EmptyTypeDefinition(mediaType, this.example, this.enumValues, this.displayName, this.description);
        }
        throw new IllegalArgumentException("");
    }

    private MediaType buildMediaType(TypeSchema typeSchema) {
        if (this.mediaType != null) {
            return this.mediaType;
        }
        if (typeSchema != null) {
            return typeSchema instanceof XmlTypeSchema ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
        }
        return null;
    }

    private TypeSchema buildTypeSchema(TypeSchemaPool typeSchemaPool, String forcedTypeSchema) {
        String rawSchema = StringUtils.isNotBlank((CharSequence)forcedTypeSchema) ? forcedTypeSchema : (this.rawSchemaSupplier != null ? this.rawSchemaSupplier.get() : null);
        return StringUtils.isNotBlank((CharSequence)rawSchema) ? new TypeSchemaBuilder(typeSchemaPool).buildTypeSchema(rawSchema, this.elementName, this.schemaPath) : null;
    }
}

