/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBindingBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.BodyBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.FieldBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorSampleDataLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorValueProviderLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterRequestBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterResponseBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseEndpointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.FieldDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class DescriptorOperationAdapterLoader {
    static void loadOperationAdapters(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            DescriptorOperationAdapterLoader.loadOperationAdapter(operationAdapterDescriptor, connectorModelBuilder);
        }
    }

    private static void loadOperationAdapter(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        OperationBuilder baseOperationBuilder = DescriptorOperationAdapterLoader.resolveBaseOperationBuilder(operationAdapterDescriptor, connectorModelBuilder);
        OperationBuilder operationBuilder = connectorModelBuilder.createOperationAdapterBuilder(operationAdapterDescriptor.getOperationId(), baseOperationBuilder);
        DescriptorOperationAdapterLoader.loadOperationAdapter(operationBuilder, operationAdapterDescriptor);
    }

    private static OperationBuilder resolveBaseOperationBuilder(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        BaseEndpointDescriptor baseEndpoint = operationAdapterDescriptor.getBaseEndpoint();
        OperationBuilder operationBuildersByOperationId = connectorModelBuilder.getOperationBuildersByOperationId(baseEndpoint).orElseThrow(() -> new IllegalArgumentException(String.format("Base operation not found %s, this is a bug.", baseEndpoint.toString())));
        if (!operationBuildersByOperationId.isAdapter()) {
            return operationBuildersByOperationId;
        }
        throw new IllegalArgumentException(String.format("Base operation %s is not an endpoint operation.", baseEndpoint.toString()));
    }

    private static void loadOperationAdapter(OperationBuilder operationBuilder, OperationAdapterDescriptor operationAdapterDescriptor) {
        operationBuilder.ignored(false);
        Optional.ofNullable(operationAdapterDescriptor.getDisplayName()).ifPresent(operationBuilder::displayName);
        Optional.ofNullable(operationAdapterDescriptor.getDescription()).ifPresent(operationBuilder::description);
        List<AuxiliarParameterBindingBuilder> requestBindings = DescriptorOperationAdapterLoader.buildRequestBindings(operationAdapterDescriptor.getRequestBindings());
        operationBuilder.requestBindings(requestBindings);
        List<AuxiliarParameterBindingBuilder> responseBindings = DescriptorOperationAdapterLoader.buildResponseBindings(operationAdapterDescriptor.getResponseBindings());
        operationBuilder.responseBindings(responseBindings);
        operationBuilder.uriParameters(DescriptorOperationAdapterLoader.filterParametersAlreadyBound(operationBuilder.getUriParameters(), requestBindings));
        operationBuilder.queryParameters(DescriptorOperationAdapterLoader.filterParametersAlreadyBound(operationBuilder.getQueryParameters(), requestBindings));
        operationBuilder.headers(DescriptorOperationAdapterLoader.filterParametersAlreadyBound(operationBuilder.getHeaders(), requestBindings));
        List parameters = operationAdapterDescriptor.getParameters();
        operationBuilder.parameters(DescriptorOperationAdapterLoader.buildParameters(parameters, operationBuilder.getBodyBuilder()));
        DescriptorOperationAdapterLoader.getBodyBinding(responseBindings).ifPresent(auxiliarParameterBindingBuilder -> {
            TypeDefinitionBuilder typeDefinitionBuilder = auxiliarParameterBindingBuilder.getTypeDefinitionBuilder();
            MediaType mediaType = typeDefinitionBuilder.getMediaType();
            Supplier<String> rawSchemaSupplier = typeDefinitionBuilder.getRawSchemaSupplier();
            if (mediaType != null && rawSchemaSupplier != null) {
                operationBuilder.forceOutputTypeSchema(rawSchemaSupplier.get()).setDefaultOutputMediaType(mediaType);
            }
        });
        operationBuilder.adapter();
        if (Optional.ofNullable(operationAdapterDescriptor.getSidecarOperation()).orElse(false).booleanValue()) {
            operationBuilder.sidecar();
        }
        DescriptorSampleDataLoader.loadSampleData((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)operationAdapterDescriptor.getSampleDataExpressionDescriptor(), operationBuilder.getSampleDataBuilder());
    }

    private static List<ParameterBuilder> filterParametersAlreadyBound(List<ParameterBuilder> parameters, List<AuxiliarParameterBindingBuilder> requestBindings) {
        if (requestBindings == null) {
            return new ArrayList<ParameterBuilder>(parameters);
        }
        return parameters.stream().filter(parameter -> !DescriptorOperationAdapterLoader.isParameterAlreadyBound(parameter, requestBindings)).collect(Collectors.toList());
    }

    private static boolean isParameterAlreadyBound(ParameterBuilder parameter, List<AuxiliarParameterBindingBuilder> requestBindings) {
        if (parameter == null) {
            throw new IllegalArgumentException();
        }
        if (requestBindings == null) {
            return false;
        }
        return requestBindings.stream().anyMatch(parameterBinding -> DescriptorOperationAdapterLoader.isSameBinding(parameter, parameterBinding));
    }

    private static Optional<AuxiliarParameterBindingBuilder> getBodyBinding(List<AuxiliarParameterBindingBuilder> requestBindings) {
        if (requestBindings == null) {
            return Optional.empty();
        }
        return requestBindings.stream().filter(DescriptorOperationAdapterLoader::isBodyBinding).findFirst();
    }

    private static boolean isSameBinding(ParameterBuilder parameter, AuxiliarParameterBindingBuilder parameterBinding) {
        return parameter.getParameterType().equals((Object)parameterBinding.getParameterType()) && parameter.getExternalName().equals(parameterBinding.getName());
    }

    private static boolean isBodyBinding(AuxiliarParameterBindingBuilder parameterBinding) {
        return parameterBinding.getParameterType().equals((Object)ParameterType.BODY);
    }

    private static List<AuxiliarParameterBindingBuilder> buildResponseBindings(AuxiliarParameterResponseBindingsDescriptor parameterBindings) {
        if (parameterBindings == null) {
            return null;
        }
        LinkedList<AuxiliarParameterBindingBuilder> parameterBindingList = new LinkedList<AuxiliarParameterBindingBuilder>();
        if (parameterBindings.getBodyBinding() != null) {
            parameterBindingList.add(DescriptorOperationAdapterLoader.buildBodyBinding(parameterBindings.getBodyBinding()));
        }
        return parameterBindingList;
    }

    private static List<AuxiliarParameterBindingBuilder> buildRequestBindings(AuxiliarParameterRequestBindingsDescriptor parameterBindings) {
        String requestBodyExpression;
        if (parameterBindings == null) {
            return null;
        }
        LinkedList<AuxiliarParameterBindingBuilder> parameterBindingList = new LinkedList<AuxiliarParameterBindingBuilder>();
        if (parameterBindings.getUriParameters() != null) {
            for (AuxiliarParameterBindingDescriptor uriParam : parameterBindings.getUriParameters()) {
                parameterBindingList.add(DescriptorOperationAdapterLoader.buildParameterBinding(uriParam, ParameterType.URI));
            }
        }
        if (parameterBindings.getQueryParameters() != null) {
            for (AuxiliarParameterBindingDescriptor queryParam : parameterBindings.getQueryParameters()) {
                parameterBindingList.add(DescriptorOperationAdapterLoader.buildParameterBinding(queryParam, ParameterType.QUERY));
            }
        }
        if (parameterBindings.getHeaders() != null) {
            for (AuxiliarParameterBindingDescriptor header : parameterBindings.getHeaders()) {
                parameterBindingList.add(DescriptorOperationAdapterLoader.buildParameterBinding(header, ParameterType.HEADER));
            }
        }
        if (parameterBindings.getBodyBindings() != null) {
            for (AuxiliarParameterBindingDescriptor body : parameterBindings.getBodyBindings()) {
                parameterBindingList.add(DescriptorOperationAdapterLoader.buildParameterBinding(body, ParameterType.BODY));
            }
        }
        if ((requestBodyExpression = parameterBindings.getRequestBodyExpression()) != null) {
            parameterBindingList.add(DescriptorOperationAdapterLoader.buildBodyParameterBinding(requestBodyExpression));
        }
        return parameterBindingList;
    }

    private static AuxiliarParameterBindingBuilder buildBodyParameterBinding(String value) {
        AuxiliarParameterBindingBuilder auxiliarParameterBindingBuilder = new AuxiliarParameterBindingBuilder(ParameterType.BODY.getName(), ParameterType.BODY);
        auxiliarParameterBindingBuilder.value(value);
        return auxiliarParameterBindingBuilder;
    }

    private static AuxiliarParameterBindingBuilder buildBodyBinding(AuxiliarBodyBindingDescriptor descriptor) {
        AuxiliarParameterBindingBuilder auxiliarParameterBindingBuilder = new AuxiliarParameterBindingBuilder(ParameterType.BODY.getName(), ParameterType.BODY);
        auxiliarParameterBindingBuilder.value(descriptor.getValue());
        String schemaType = descriptor.getMediaType();
        if (StringUtils.isNotBlank((CharSequence)schemaType)) {
            TypeDefinitionBuilder typeDefinitionBuilder = auxiliarParameterBindingBuilder.getTypeDefinitionBuilder();
            typeDefinitionBuilder.object().typeSchema(() -> ((AuxiliarBodyBindingDescriptor)descriptor).getMediaType());
            typeDefinitionBuilder.mediaType(DescriptorOperationAdapterLoader.loadMediaType(descriptor.getContentType()));
        }
        return auxiliarParameterBindingBuilder;
    }

    private static AuxiliarParameterBindingBuilder buildParameterBinding(AuxiliarParameterBindingDescriptor descriptor, ParameterType parameterType) {
        AuxiliarParameterBindingBuilder auxiliarParameterBindingBuilder = new AuxiliarParameterBindingBuilder(descriptor.getName(), parameterType);
        auxiliarParameterBindingBuilder.value(descriptor.getValue());
        auxiliarParameterBindingBuilder.ignored(descriptor.getIgnored());
        String schemaType = descriptor.getInputType();
        if (StringUtils.isNotBlank((CharSequence)schemaType)) {
            TypeDefinitionBuilder typeDefinitionBuilder = auxiliarParameterBindingBuilder.getTypeDefinitionBuilder();
            typeDefinitionBuilder.object().typeSchema(() -> ((AuxiliarParameterBindingDescriptor)descriptor).getInputType());
            typeDefinitionBuilder.mediaType(DescriptorOperationAdapterLoader.loadMediaType(descriptor.getContentType()));
        }
        return auxiliarParameterBindingBuilder;
    }

    private static List<AuxiliarParameterBuilder> buildParameters(List<AuxiliarParameterDescriptor> parameterDescriptors, BodyBuilder bodyBuilder) {
        LinkedList<AuxiliarParameterBuilder> parameters = new LinkedList<AuxiliarParameterBuilder>();
        if (parameterDescriptors != null) {
            for (AuxiliarParameterDescriptor parameterDescriptor : parameterDescriptors) {
                parameters.add(DescriptorOperationAdapterLoader.buildParameter(parameterDescriptor, bodyBuilder));
            }
        }
        return parameters;
    }

    private static AuxiliarParameterBuilder buildParameter(AuxiliarParameterDescriptor parameterDescriptor, BodyBuilder bodyBuilder) {
        AuxiliarParameterBuilder auxiliarParameterBuilder = new AuxiliarParameterBuilder(parameterDescriptor.getName());
        auxiliarParameterBuilder.displayName(parameterDescriptor.getDisplayName()).description(parameterDescriptor.getDescription()).required(parameterDescriptor.isRequired());
        DataTypeDescriptor dataType = parameterDescriptor.getDataType();
        if (dataType != null) {
            ParameterDataType parameterDataType = ParameterDataType.forName(dataType.getName());
            auxiliarParameterBuilder.dataType(parameterDataType);
        } else {
            TypeDefinitionBuilder typeDefinitionBuilder = auxiliarParameterBuilder.getTypeDefinitionBuilder();
            if (StringUtils.isNotBlank((CharSequence)parameterDescriptor.getInputType())) {
                typeDefinitionBuilder.object().typeSchema(() -> ((AuxiliarParameterDescriptor)parameterDescriptor).getInputType());
            }
            typeDefinitionBuilder.mediaType(DescriptorOperationAdapterLoader.loadMediaType(parameterDescriptor.getContentType()));
        }
        DescriptorValueProviderLoader.loadValueProvider((ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>)parameterDescriptor.getValueProvider(), auxiliarParameterBuilder.getValueProviderExpressionBuilder());
        DescriptorOperationAdapterLoader.loadBody(parameterDescriptor.getFieldDescriptors(), auxiliarParameterBuilder);
        return auxiliarParameterBuilder;
    }

    private static void loadBody(List<FieldDescriptor> fieldDescriptors, AuxiliarParameterBuilder auxiliarParameterBuilder) {
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            FieldBuilder fieldBuilder = new FieldBuilder(fieldDescriptor.getParamName());
            DescriptorValueProviderLoader.loadValueProvider((ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>)fieldDescriptor.getValueProviders(), fieldBuilder.getValueProviderBuilder());
            auxiliarParameterBuilder.getFieldBuilders().add(fieldBuilder);
        }
    }

    private static MediaType loadMediaType(String contentType) {
        return StringUtils.isEmpty((CharSequence)contentType) ? null : MediaType.valueOf((String)contentType);
    }
}

