/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.util.List;
import java.util.Optional;


public class ConnectorOperation {

  /**
   * Identifier for this operation, either consumed from the SPEC or generated from method+path.
   */
  private final String operationIdentifier;

  /**
   * XML name used to identify this operation internally.
   */
  private final String internalName;

  /**
   * User friendly name for this parameter
   */
  private final String displayName;

  private final String description;
  /**
   * Mapping key name defined for a multiple base path type.
   */
  private final String alternativeBaseUri;
  private final String path;
  private final HTTPMethod httpMethod;
  private final List<String> baseUris;
  private final Pagination pagination;
  private final List<Parameter> uriParameters;
  private final List<Parameter> queryParameters;
  private final List<Parameter> headers;
  private final Body body;

  private final List<AuxiliarParameter> parameters;
  private final List<ParameterBinding> requestBindings;
  private final List<ParameterBinding> responseBindings;

  private final TypeDefinition inputMetadata;
  private final TypeDefinition outputMetadata;

  private final Boolean skipOutputTypeValidation;
  private final Boolean voidOperation;
  private final QueryParamArrayFormat queryParamArrayFormat;

  private final boolean isAdapter;
  private final boolean isSidecar;

  /**
   * This field indicates if the operation is not meant to be generated in the generated connector.
   */
  private final boolean isIgnored;

  private final List<ConnectorSecurityScheme> securitySchemes;

  private ResolverExpression<SampleDataDefinition> sampleData;

  public ConnectorOperation(
                            String operationIdentifier,
                            String displayName,
                            String description,
                            String path,
                            List<String> baseUris,
                            HTTPMethod httpMethod,
                            List<Parameter> uriParameters,
                            List<Parameter> queryParameters,
                            List<Parameter> headers,
                            List<AuxiliarParameter> parameters,
                            List<ParameterBinding> requestBindings,
                            List<ParameterBinding> responseBindings,
                            Body body,
                            TypeDefinition inputMetadata,
                            TypeDefinition outputMetadata,
                            List<ConnectorSecurityScheme> securitySchemes,
                            String alternativeBaseUri,
                            Pagination pagination,
                            Boolean skipOutputTypeValidation,
                            Boolean voidOperation,
                            QueryParamArrayFormat queryParamArrayFormat,
                            boolean isIgnored, boolean isAdapter, boolean isSidecar) {

    this.operationIdentifier = operationIdentifier;
    this.parameters = parameters;
    this.requestBindings = requestBindings;
    this.responseBindings = responseBindings;
    this.isAdapter = isAdapter;
    this.isSidecar = isSidecar;
    this.internalName = getXmlName(this.operationIdentifier.replaceAll("/", "-"));
    this.displayName = displayName;
    this.description = description;
    this.path = path;
    this.httpMethod = httpMethod;
    this.baseUris = baseUris;

    this.uriParameters = uriParameters;
    this.queryParameters = queryParameters;
    this.headers = headers;
    this.body = body;
    this.inputMetadata = inputMetadata;
    this.outputMetadata = outputMetadata;
    this.securitySchemes = securitySchemes;

    this.alternativeBaseUri = alternativeBaseUri;
    this.pagination = pagination;

    this.skipOutputTypeValidation = skipOutputTypeValidation;
    this.voidOperation = voidOperation;
    this.queryParamArrayFormat = queryParamArrayFormat;

    this.isIgnored = isIgnored;
  }

  public String getOperationIdentifier() {
    return operationIdentifier;
  }

  public List<Parameter> getQueryParameters() {
    return queryParameters;
  }

  public List<Parameter> getUriParameters() {
    return uriParameters;
  }

  public List<Parameter> getHeaders() {
    return headers;
  }

  public Body getBody() {
    return body;
  }

  public HTTPMethod getHttpMethod() {
    return httpMethod;
  }

  public List<String> getBaseUris() {
    return baseUris;
  }

  public String getPath() {
    return path;
  }

  public String getDescription() {
    return description;
  }

  public TypeDefinition getInputMetadata() {
    return inputMetadata;
  }

  public TypeDefinition getOutputMetadata() {
    return outputMetadata;
  }

  public List<ConnectorSecurityScheme> getSecuritySchemes() {
    return securitySchemes;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getAlternativeBaseUri() {
    return alternativeBaseUri;
  }

  public Pagination getPagination() {
    return pagination;
  }

  public boolean hasPagination() {
    return this.pagination != null;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }

  public Boolean getVoidOperation() {
    return voidOperation;
  }

  public QueryParamArrayFormat getQueryParamArrayFormat() {
    return queryParamArrayFormat;
  }

  public boolean isIgnored() {
    return isIgnored;
  }

  public ResolverExpression<SampleDataDefinition> getSampleData() {
    return sampleData;
  }

  public void setSampleData(ResolverExpression<SampleDataDefinition> sampleData) {
    this.sampleData = sampleData;
  }

  public Optional<List<AuxiliarParameter>> getParameters() {
    return Optional.ofNullable(parameters);
  }

  public Optional<List<ParameterBinding>> getRequestBindings() {
    return Optional.ofNullable(requestBindings);
  }

  public Optional<List<ParameterBinding>> getResponseBindings() {
    return Optional.ofNullable(responseBindings);
  }

  public boolean isAdapter() {
    return isAdapter;
  }

  public boolean isSidecar() {
    return isSidecar;
  }

  public boolean isRequestBodyBound() {
    return getRequestBindings().map(parameterBindings -> parameterBindings.stream().anyMatch(this::isBodyBinding)).orElse(false);
  }

  private boolean isBodyBinding(ParameterBinding parameterBinding) {
    return parameterBinding.getParameterType().equals(ParameterType.BODY);
  }
}
