/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiOperationLoader.loadOperations;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiSecuritySchemeLoader.loadSecuritySchemes;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri.Type.PARAMETER;
import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.List;

public class ApiConnectorModelLoader {

  public static ConnectorModelBuilder load(APIModel apiModel, ConnectorModelBuilder connectorModelBuilder) {

    List<Protocol> supportedProtocols = apiModel.getProtocols().stream().map(Protocol::getFromString).collect(toList());

    connectorModelBuilder
        .name(apiModel.getApiName())
        .description(apiModel.getDescription())
        .supportedProtocols(supportedProtocols);

    connectorModelBuilder
        .getBaseUriBuilder()
        .setType(PARAMETER)
        .setApiVersion(apiModel.getApiVersion())
        .setUri(apiModel.getBaseUri());

    loadSecuritySchemes(apiModel, connectorModelBuilder);

    loadOperations(apiModel, connectorModelBuilder);

    return connectorModelBuilder;
  }
}
