/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination;

public class Pagination {

  private final String name;
  private final PaginationType type;
  private final String paginationParameter;
  private final String nextTokenExpression;
  private final String initialOffset;
  private final String initialPageNumber;
  private final String paginationResponseExpression;
  private final String pageCountExpression;
  private final String nextUrlExpression;

  public Pagination(String name, PaginationType type, String paginationParameter, String nextTokenExpression,
                    String initialOffset, String initialPageNumber, String paginationResponseExpression,
                    String pageCountExpression, String nextUrlExpression) {
    this.name = name;
    this.type = type;
    this.paginationParameter = paginationParameter;
    this.nextTokenExpression = nextTokenExpression;
    this.paginationResponseExpression = paginationResponseExpression;
    this.initialOffset = initialOffset;
    this.initialPageNumber = initialPageNumber;
    this.pageCountExpression = pageCountExpression;
    this.nextUrlExpression = nextUrlExpression;
  }

  public String getName() {
    return name;
  }

  public PaginationType getType() {
    return type;
  }

  public String getPaginationParameter() {
    return paginationParameter;
  }

  public String getNextTokenExpression() {
    return nextTokenExpression;
  }

  public String getPaginationResponseExpression() {
    return paginationResponseExpression;
  }

  public String getInitialOffset() {
    return initialOffset;
  }

  public String getInitialPageNumber() {
    return initialPageNumber;
  }

  public String getPageCountExpression() {
    return pageCountExpression;
  }

  public String getNextUrlExpression() {
    return nextUrlExpression;
  }
}
