/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.BaseUriBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorOperationAdapterLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorOperationLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorPaginationLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorSecuritySchemeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTestConnectionLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTriggerLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseUriDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import org.apache.commons.lang3.StringUtils;

public class DescriptorConnectorModelLoader {
    public static ConnectorModelBuilder load(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        if (connectorDescriptor.getIgnoreOperations() != null) {
            connectorModelBuilder.setAllOperationsIgnored(connectorDescriptor.getIgnoreOperations());
        }
        connectorModelBuilder.name(connectorDescriptor.getConnectorName()).description(connectorDescriptor.getConnectorDescription()).baseJavaPackage(connectorDescriptor.getBaseJavaPackage()).category(DescriptorConnectorModelLoader.loadConnectorCategory(connectorDescriptor)).extensionXml(connectorDescriptor.getExtensionXml()).skipOutputTypeValidation(connectorDescriptor.getSkipOutputTypeValidation()).queryParamArrayFormat(DescriptorConnectorModelLoader.loadQueryParamArrayFormat(connectorDescriptor.getQueryParamArrayFormat())).operationIdentifierExpression(DescriptorConnectorModelLoader.loadOperationIdentifierExpression(connectorDescriptor)).operationDisplayNameExpression(DescriptorConnectorModelLoader.loadDisplayNameExpression(connectorDescriptor)).parameterIdentifierExpression(DescriptorConnectorModelLoader.loadParameterIdentifierExpression(connectorDescriptor)).bodyIdentifierExpression(DescriptorConnectorModelLoader.loadBodyIdentifierExpression(connectorDescriptor)).defaultInputMediaType(DescriptorTypeLoader.loadMediaType(connectorDescriptor.getDefaultInputMediaType())).defaultOutputMediaType(DescriptorTypeLoader.loadMediaType(connectorDescriptor.getDefaultOutputMediaType())).testConnection(DescriptorTestConnectionLoader.loadTestConnection(connectorDescriptor.getTestConnection()));
        DescriptorConnectorModelLoader.loadGav(connectorDescriptor, connectorModelBuilder);
        DescriptorConnectorModelLoader.loadBaseUri(connectorDescriptor.getBaseUri(), connectorModelBuilder.getBaseUriBuilder());
        DescriptorOperationLoader.loadOperations(connectorDescriptor, connectorModelBuilder);
        DescriptorOperationAdapterLoader.loadOperationAdapters(connectorDescriptor, connectorModelBuilder);
        DescriptorPaginationLoader.loadPaginations(connectorDescriptor, connectorModelBuilder);
        DescriptorTriggerLoader.loadTriggers(connectorDescriptor, connectorModelBuilder);
        DescriptorSecuritySchemeLoader.loadSecuritySchemes(connectorDescriptor, connectorModelBuilder);
        return connectorModelBuilder;
    }

    private static void loadGav(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        MavenGavDescriptor connectorGav = connectorDescriptor.getConnectorGav();
        if (connectorGav == null) {
            return;
        }
        connectorModelBuilder.mavenGroup(connectorGav.getGroupId()).mavenArtifactId(connectorGav.getArtifactId()).mavenVersion(connectorGav.getVersion());
    }

    private static String loadOperationIdentifierExpression(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getOperationIdentifier() != null ? connectorDescriptor.getOperationIdentifier().getExpression() : null;
    }

    private static String loadDisplayNameExpression(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getOperationDisplayName() != null ? connectorDescriptor.getOperationDisplayName().getExpression() : null;
    }

    private static String loadParameterIdentifierExpression(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getParameterIdentifier() != null ? connectorDescriptor.getParameterIdentifier().getExpression() : null;
    }

    private static String loadBodyIdentifierExpression(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getBodyIdentifier() != null ? connectorDescriptor.getBodyIdentifier().getExpression() : null;
    }

    private static QueryParamArrayFormat loadQueryParamArrayFormat(String format) {
        if (StringUtils.isNotBlank((CharSequence)format)) {
            return QueryParamArrayFormat.valueOf(format.toUpperCase());
        }
        return null;
    }

    private static void loadBaseUri(BaseUriDescriptor baseUriDescriptor, BaseUriBuilder baseUriBuilder) {
        if (baseUriDescriptor != null) {
            baseUriBuilder.setUri(baseUriDescriptor.getValue()).setType(BaseUri.Type.valueOfName(baseUriDescriptor.getType()));
            baseUriDescriptor.getMapping().forEach(x -> baseUriBuilder.addMultipleBaseUri(x.getName(), x.getValue(), x.isDefault()));
        }
    }

    private static ConnectorCategory loadConnectorCategory(ConnectorDescriptor connectorDescriptor) {
        return ConnectorCategory.fromString(connectorDescriptor.getConnectorCategory());
    }
}

