/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BasicAuthDefaultParameters;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme.SecuritySchemeType.BASIC;

public class BasicAuthScheme extends ConnectorSecurityScheme {

  private final BasicAuthDefaultParameters basicAuthDefaultParameters;

  public BasicAuthScheme(String displayName, BasicAuthDefaultParameters basicAuthDefaultParameters,
                         TestConnectionConfig testConnectionConfig) {
    super(BASIC, displayName, testConnectionConfig);
    this.basicAuthDefaultParameters = basicAuthDefaultParameters;
  }

  public BasicAuthDefaultParameters getBasicAuthDefaultParameters() {
    return basicAuthDefaultParameters;
  }
}
