/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BearerAuthDefaultParameters;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme.SecuritySchemeType.BEARER;

public class BearerAuthScheme extends ConnectorSecurityScheme {

  private final BearerAuthDefaultParameters bearerAuthDefaultParameters;

  public BearerAuthScheme(String displayName,
                          BearerAuthDefaultParameters bearerAuthDefaultParameters,
                          TestConnectionConfig testConnectionConfig) {
    super(BEARER, displayName, testConnectionConfig);
    this.bearerAuthDefaultParameters = bearerAuthDefaultParameters;
  }

  public BearerAuthDefaultParameters getBearerAuthDefaultParameters() {
    return bearerAuthDefaultParameters;
  }
}
