/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme.SecuritySchemeType.UNSECURED;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class ConnectorSecurityScheme {

  public enum SecuritySchemeType {

    BASIC("Basic Authentication"), OAUTH1("OAuth 1.0"), OAUTH2("OAuth 2.0"), PASS_THROUGH("Pass Through"), DIGEST_AUTHENTICATION(
        "Digest Authentication"), CUSTOM_AUTHENTICATION(
            "Custom Authentication"), BEARER("Bearer Authentication"), UNSECURED("Unsecured"), NOT_SUPPORTED("Not Supported");

    private final String type;

    SecuritySchemeType(String type) {
      this.type = type;
    }

    @Override
    public String toString() {
      return this.type;
    }
  }

  protected final List<Parameter> headers = new ArrayList<>();
  protected final List<Parameter> queryParameters = new ArrayList<>();
  protected final SecuritySchemeType schemeType;
  protected final String name;
  protected final TestConnectionConfig testConnectionConfig;

  public ConnectorSecurityScheme(
                                 SecuritySchemeType schemeType, String name, TestConnectionConfig testConnectionConfig) {
    this.schemeType = schemeType;
    this.name = name;
    this.testConnectionConfig = testConnectionConfig;
  }

  public SecuritySchemeType getSchemeType() {
    return this.schemeType;
  }

  public String getName() {
    if (schemeType.equals(UNSECURED)) {
      return UNSECURED.name();
    } else {
      return name;
    }
  }

  public TestConnectionConfig getTestConnectionConfig() {
    return testConnectionConfig;
  }

  public List<Parameter> getQueryParameters() {
    return queryParameters;
  }

  public List<Parameter> getHeaders() {
    return headers;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (!(o instanceof ConnectorSecurityScheme))
      return false;

    ConnectorSecurityScheme that = (ConnectorSecurityScheme) o;

    return that.hashCode() == this.hashCode();
  }

  @Override
  public int hashCode() {
    return HashCodeUtil.generateHashCode(schemeType, headers, queryParameters);
  }
}
