/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.DigestAuthDefaultParameters;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme.SecuritySchemeType.DIGEST_AUTHENTICATION;

public class DigestAuthenticationScheme extends ConnectorSecurityScheme {

  private final DigestAuthDefaultParameters digestAuthDefaultParameters;

  public DigestAuthenticationScheme(String displayName, DigestAuthDefaultParameters digestAuthDefaultParameters,
                                    TestConnectionConfig testConnectionConfig) {
    super(DIGEST_AUTHENTICATION, displayName, testConnectionConfig);
    this.digestAuthDefaultParameters = digestAuthDefaultParameters;
  }

  public DigestAuthDefaultParameters getDigestAuthDefaultParameters() {
    return digestAuthDefaultParameters;
  }
}
