/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;

public class ComparisonUtil {

  /**
   *
   * @param exName1 external name to be compared
   * @param exName2 external name to be compared
   * @param parameterType type of parameter, only if it is QUERY or URI type, according to RFC 6570, query params values could be
   *        case sensitive, so comparison will be equals. Same as URI. /{Param}/{PARAM}/ could exists and has to be different
   *        parameters
   * @return result of comparison
   */
  public static boolean externalNameParamsComparison(String exName1, String exName2, ParameterType parameterType) {
    if (parameterType.equals(ParameterType.QUERY) || parameterType.equals(ParameterType.URI)) {
      return exName1.equals(exName2);
    }
    return exName1.equalsIgnoreCase(exName2);
  }
}
