/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.FieldBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class AuxiliarParameterBuilder {
    private final String name;
    private String displayName;
    private ParameterDataType dataType;
    private final TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
    private String description;
    private Boolean required;
    private final ValueProviderBuilder valueProviderExpressionBuilder = new ValueProviderBuilder();
    private String muleMetadataKeyId;
    private String muleTypeResolver;
    private final List<FieldBuilder> fieldBuilders = new ArrayList<FieldBuilder>();

    public AuxiliarParameterBuilder(String name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ValueProviderBuilder getValueProviderExpressionBuilder() {
        return this.valueProviderExpressionBuilder;
    }

    public AuxiliarParameterBuilder displayName(String displayName) {
        this.displayName = (String)ObjectUtils.defaultIfNull((Object)displayName, (Object)this.displayName);
        return this;
    }

    public AuxiliarParameterBuilder dataType(ParameterDataType dataType) {
        this.dataType = (ParameterDataType)((Object)ObjectUtils.defaultIfNull((Object)((Object)dataType), (Object)((Object)this.dataType)));
        return this;
    }

    public AuxiliarParameterBuilder description(String description) {
        this.description = (String)ObjectUtils.defaultIfNull((Object)description, (Object)this.description);
        return this;
    }

    public AuxiliarParameterBuilder required(Boolean required) {
        this.required = (Boolean)ObjectUtils.defaultIfNull((Object)required, (Object)this.required);
        return this;
    }

    public AuxiliarParameterBuilder muleMetadataKeyId(String muleMetadataKeyId) {
        this.muleMetadataKeyId = (String)ObjectUtils.defaultIfNull((Object)muleMetadataKeyId, (Object)this.muleMetadataKeyId);
        return this;
    }

    public AuxiliarParameterBuilder muleTypeResolver(String muleTypeResolver) {
        this.muleTypeResolver = (String)ObjectUtils.defaultIfNull((Object)muleTypeResolver, (Object)this.muleTypeResolver);
        return this;
    }

    public TypeDefinitionBuilder getTypeDefinitionBuilder() {
        return this.typeDefinitionBuilder;
    }

    public List<FieldBuilder> getFieldBuilders() {
        return this.fieldBuilders;
    }

    private List<Field> buildFields() {
        return this.fieldBuilders.stream().map(FieldBuilder::buildField).collect(Collectors.toList());
    }

    public AuxiliarParameter build() {
        return new AuxiliarParameter(this.name, this.displayName, this.dataType, null, this.description, this.required, this.valueProviderExpressionBuilder.build(), this.muleMetadataKeyId, this.muleTypeResolver, this.buildFields());
    }

    public AuxiliarParameter build(TypeSchemaPool typeSchemaPool) {
        TypeDefinition typeDefinition = null;
        if (this.dataType == null) {
            typeDefinition = this.getTypeDefinitionBuilder().build(typeSchemaPool, null);
        }
        AuxiliarParameter auxiliarParameter = new AuxiliarParameter(this.name, this.displayName, this.dataType, typeDefinition, this.description, this.required, this.valueProviderExpressionBuilder.build(), this.muleMetadataKeyId, this.muleTypeResolver, this.buildFields());
        return auxiliarParameter;
    }
}

