/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorSampleDataLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import java.util.List;
import java.util.Optional;

public class DescriptorTriggerLoader {
    static void loadTriggers(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorBuilder) {
        if (connectorDescriptor.getTriggers() == null) {
            return;
        }
        connectorDescriptor.getTriggers().stream().filter(triggerDescriptor -> triggerDescriptor.getBase() == null).forEach(triggerDescriptor -> DescriptorTriggerLoader.loadTrigger(triggerDescriptor, connectorBuilder.getOrCreateTriggerBuilder(triggerDescriptor.getName())));
        connectorDescriptor.getTriggers().stream().filter(triggerDescriptor -> triggerDescriptor.getBase() != null).forEach(triggerDescriptor -> DescriptorTriggerLoader.loadTriggerAdapter(triggerDescriptor, connectorBuilder));
    }

    private static void loadTrigger(TriggerDescriptor triggerDescriptor, TriggerBuilder triggerBuilder) {
        triggerBuilder.path(triggerDescriptor.getPath()).method(triggerDescriptor.getMethod() != null ? HTTPMethod.fromString(triggerDescriptor.getMethod().getName()) : null).itemsExpression(triggerDescriptor.getItemsExpression()).outputMediaType(triggerDescriptor.getOutputMediaType()).identityExpression(triggerDescriptor.getIdentityExpression()).outputTypeSchema(triggerDescriptor.getOutputTypeSchema()).displayName(triggerDescriptor.getDisplayName()).setDescription(triggerDescriptor.getDescription()).ignored(triggerDescriptor.getIgnored()).eventExpression(triggerDescriptor.getEventExpression()).startValue(triggerDescriptor.getStartValueExpression());
        if (triggerDescriptor.getWatermark() != null) {
            triggerBuilder.watermarkExpression(triggerDescriptor.getWatermark().getExtraction());
            if (triggerDescriptor.getWatermark().getDataType() != null) {
                triggerBuilder.watermarkType(ParameterDataType.forName(triggerDescriptor.getWatermark().getDataType().getName()));
            }
        }
        DescriptorTriggerLoader.loadParameterBindings(triggerBuilder, triggerDescriptor);
        DescriptorTriggerLoader.loadParameters(triggerBuilder, triggerDescriptor);
        DescriptorSampleDataLoader.loadSampleData((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)triggerDescriptor.getSampleDataExpressionDescriptor(), triggerBuilder.getSampleDataExpressionBuilder());
    }

    private static void loadTriggerAdapter(TriggerDescriptor triggerAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        TriggerBuilder baseTriggerBuilder = DescriptorTriggerLoader.resolveBaseTriggerBuilder(triggerAdapterDescriptor, connectorModelBuilder);
        TriggerBuilder triggerBuilder = connectorModelBuilder.createTriggerAdapterBuilder(triggerAdapterDescriptor.getName(), baseTriggerBuilder);
        if (Optional.ofNullable(triggerAdapterDescriptor.getSidecarTrigger()).orElse(false).booleanValue()) {
            triggerBuilder.sidecar();
        }
        Optional.ofNullable(triggerAdapterDescriptor.getDisplayName()).ifPresent(triggerBuilder::displayName);
        Optional.ofNullable(triggerAdapterDescriptor.getDescription()).ifPresent(triggerBuilder::setDescription);
        Optional.ofNullable(triggerAdapterDescriptor.getEventExpression()).ifPresent(triggerBuilder::eventExpression);
        Optional.ofNullable(triggerAdapterDescriptor.getStartValueExpression()).ifPresent(triggerBuilder::startValue);
        Optional.ofNullable(triggerAdapterDescriptor.getOutputMediaType()).ifPresent(triggerBuilder::outputMediaType);
        Optional.ofNullable(triggerAdapterDescriptor.getOutputTypeSchema()).ifPresent(triggerBuilder::outputTypeSchema);
        DescriptorTriggerLoader.loadParameters(triggerBuilder, triggerAdapterDescriptor);
        DescriptorTriggerLoader.loadParameterBindings(triggerBuilder, triggerAdapterDescriptor);
        DescriptorSampleDataLoader.loadSampleData((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)triggerAdapterDescriptor.getSampleDataExpressionDescriptor(), triggerBuilder.getSampleDataExpressionBuilder());
    }

    private static TriggerBuilder resolveBaseTriggerBuilder(TriggerDescriptor triggerAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        String baseTriggerName = triggerAdapterDescriptor.getBase();
        TriggerBuilder triggerBuildersByTriggerName = connectorModelBuilder.getTriggerBuildersByName(baseTriggerName).orElseThrow(() -> new IllegalArgumentException(String.format("Base trigger not found %s, this is a bug.", baseTriggerName)));
        return triggerBuildersByTriggerName;
    }

    private static void loadParameterBindings(TriggerBuilder triggerBuilder, TriggerDescriptor triggerDescriptor) {
        if (triggerDescriptor.getParameterBindings() == null) {
            return;
        }
        triggerBuilder.requestBodyExpression(triggerDescriptor.getParameterBindings().getRequestBodyExpression());
        DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getUriParameters(), ParameterType.URI, triggerBuilder);
        DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getQueryParameters(), ParameterType.QUERY, triggerBuilder);
        DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getHeaders(), ParameterType.HEADER, triggerBuilder);
    }

    private static void loadParameterBindings(List<ParameterBindingDescriptor> parameterBindings, ParameterType parameterType, TriggerBuilder triggerBuilder) {
        for (ParameterBindingDescriptor bindingDescriptor : parameterBindings) {
            triggerBuilder.getOrCreateParameterBindingBuilder(bindingDescriptor.getName(), parameterType).value(bindingDescriptor.getValue());
        }
    }

    private static void loadParameters(TriggerBuilder triggerBuilder, TriggerDescriptor triggerDescriptor) {
        if (triggerDescriptor.getParameters() == null) {
            return;
        }
        for (TriggerParameterDescriptor parameterDescriptor : triggerDescriptor.getParameters()) {
            triggerBuilder.getOrCreateParameterBuilder(parameterDescriptor.getName()).displayName(parameterDescriptor.getDisplayName()).description(parameterDescriptor.getDescription()).dataType(ParameterDataType.forName(parameterDescriptor.getDataType().getName())).required(parameterDescriptor.isRequired());
        }
    }
}

