/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationKind;


public class PaginationBuilder {

  private final String name;
  private PaginationKind kind;
  private String paginationParameterName;
  private String nextTokenExpression;
  private String initialOffset;
  private String initialPageNumber;
  private String pagingResponseExpression;
  private String pageCountExpression;
  private String nextUrlExpression;

  PaginationBuilder(String name) {
    requireNonNull(name);

    this.name = name;
  }

  public String getName() {
    return name;
  }

  public PaginationBuilder kind(PaginationKind kind) {
    this.kind = defaultIfNull(kind, this.kind);
    return this;
  }

  public PaginationBuilder paginationParameterName(String paginationParameterName) {
    this.paginationParameterName = defaultIfNull(paginationParameterName, this.paginationParameterName);
    return this;
  }

  public PaginationBuilder nextTokenExpression(String nextTokenExpression) {
    this.nextTokenExpression = defaultIfNull(nextTokenExpression, this.nextTokenExpression);
    return this;
  }

  public PaginationBuilder initialOffset(String initialOffset) {
    this.initialOffset = defaultIfNull(initialOffset, this.initialOffset);
    return this;
  }

  public PaginationBuilder initialPageNumber(String initialPageNumber) {
    this.initialPageNumber = defaultIfNull(initialPageNumber, this.initialPageNumber);
    return this;
  }

  public PaginationBuilder pagingResponseExpression(String pagingResponseExpression) {
    this.pagingResponseExpression = defaultIfNull(pagingResponseExpression, this.pagingResponseExpression);
    return this;
  }

  public PaginationBuilder pageCountExpression(String pageCountExpression) {
    this.pageCountExpression = defaultIfNull(pageCountExpression, this.pageCountExpression);
    return this;
  }

  public PaginationBuilder nextUrlExpression(String nextUrlExpression) {
    this.nextUrlExpression = defaultIfNull(nextUrlExpression, this.nextUrlExpression);
    return this;
  }

  Pagination build() {
    requireNonNull(kind);

    return new Pagination(name,
                          kind,
                          paginationParameterName,
                          nextTokenExpression,
                          initialOffset,
                          initialPageNumber,
                          pagingResponseExpression,
                          pageCountExpression,
                          nextUrlExpression);
  }
}
