/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import static java.util.Objects.requireNonNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverParameter;

import java.util.List;

public abstract class ResolverDeclarationBuilder<T extends ResolverDefinitionBuilder<U>, U extends ResolverDefinition<U>> {

  private final String name;
  private final T resolverDefinitionBuilder;

  private List<ResolverParameter> parameters;

  protected ResolverDeclarationBuilder(String name, T resolverDefinitionBuilder) {
    requireNonNull(name);
    requireNonNull(resolverDefinitionBuilder);

    this.name = name;
    this.resolverDefinitionBuilder = resolverDefinitionBuilder;
  }

  public T getDefinitionBuilder() {
    return this.resolverDefinitionBuilder;
  }

  public ResolverDeclarationBuilder<T, U> parameters(List<ResolverParameter> parameters) {
    this.parameters = parameters;
    return this;
  }

  public ResolverDeclaration<U> build() {
    return new ResolverDeclaration<>(name, resolverDefinitionBuilder.build(), parameters);
  }
}
