/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader.loadDataType;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorValueProviderLoader.loadValueProvider;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;

import java.util.List;

public class DescriptorParameterLoader {

  static void loadParameters(List<ParameterDescriptor> parameters,
                             ParameterType parameterType,
                             OperationBuilder operationBuilder) {

    for (ParameterDescriptor parameterDescriptor : parameters) {
      ParameterBuilder parameterBuilder =
          operationBuilder.getOrCreateParameterBuilder(parameterType, parameterDescriptor.getParamName(),
                                                       parameterDescriptor.getParameterIdentifier());
      loadParameter(parameterDescriptor, parameterBuilder);
    }
  }

  private static void loadParameter(ParameterDescriptor parameterDescriptor,
                                    ParameterBuilder parameterBuilder) {

    parameterBuilder
        .parameterIdentifier(parameterDescriptor.getParameterIdentifier())
        .displayName(parameterDescriptor.getDisplayName())
        .description(parameterDescriptor.getDescription())
        .required(parameterDescriptor.getRequired())
        .muleAlias(parameterDescriptor.getMuleAlias())
        .defaultValue(parameterDescriptor.getDefaultValue())
        .ignored(parameterDescriptor.isIgnored())
        .summary(parameterDescriptor.getSummary());

    if (parameterDescriptor.getDataType() != null) {
      loadDataType(parameterDescriptor, parameterBuilder.getTypeDefinitionBuilder());
    }

    if (parameterDescriptor.getValueProvider() != null) {
      loadValueProvider(parameterDescriptor.getValueProvider(), parameterBuilder.getValueProviderBuilder());
    }
  }
}
