/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.PART;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

public class PartParameter extends Parameter {
  // TODO RSDK-620 revisit this class, seems odd to extend from Parameter, specially all of the null values in the constructor

  private final boolean isFilePart;

  public PartParameter(String partIdentifier, String displayName, String externalName, TypeDefinition typeDefinition,
                       String description, boolean isFilePart, String summary) {
    super(
          partIdentifier,
          getXmlName(partIdentifier),
          displayName,
          externalName,
          PART,
          typeDefinition,
          null,
          description,
          false,
          null,
          false,
          null,
          null,
          null,
          null,
          null,
          summary);
    this.isFilePart = isFilePart;
  }

  public boolean isFilePart() {
    return isFilePart;
  }
}
