/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;

import javax.ws.rs.core.MediaType;
import java.util.List;

public class PrimitiveTypeDefinition extends TypeDefinition {

  private final PrimitiveType primitiveType;

  public PrimitiveTypeDefinition(MediaType mediaType, String example, List<String> enumValues, TypeSchema typeSchema,
                                 PrimitiveType primitiveType, String displayName, String description) {
    super(mediaType, example, enumValues, typeSchema, displayName, description);
    this.primitiveType = primitiveType;
  }

  public PrimitiveType getPrimitiveType() {
    return primitiveType;
  }

  public enum PrimitiveType {
    BOOLEAN, DATE, DATE_ONLY, DATE_TIME_ONLY, DATE_TIME, FILE, NUMBER, INTEGER, STRING, TIME_ONLY, ZONED_DATE_TIME, LOCAL_DATE_TIME, LONG, BINARY
  }
}
