/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.Expression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpRequestBinding {
    private final List<Argument> uriParameter;
    private final List<Argument> queryParameter;
    private final List<Argument> header;

    public HttpRequestBinding(List<Argument> uriParameter, List<Argument> queryParameter, List<Argument> header) {
        this.uriParameter = uriParameter;
        this.queryParameter = queryParameter;
        this.header = header;
    }

    public List<Argument> getUriParameter() {
        return this.uriParameter;
    }

    public List<Argument> getQueryParameter() {
        return this.queryParameter;
    }

    public List<Argument> getHeader() {
        return this.header;
    }

    public List<Expression> getUriParameterExpressions() {
        return this.uriParameter.stream().map(argument -> argument.getValue()).collect(Collectors.toList());
    }

    public List<Expression> getQueryParameterExpressions() {
        return this.queryParameter.stream().map(argument -> argument.getValue()).collect(Collectors.toList());
    }

    public List<Expression> getHeaderExpressions() {
        return this.header.stream().map(argument -> argument.getValue()).collect(Collectors.toList());
    }

    public List<Expression> getAllExpressions() {
        return Stream.of(this.getUriParameterExpressions(), this.getHeaderExpressions(), this.getQueryParameterExpressions()).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

