/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import java.util.List;

public class ApiParameterLoader {
    static void loadSecuritySchemeParameters(List<APIParameterModel> apiParameters, ParameterType parameterType, SecuritySchemeBuilder securitySchemeBuilder) {
        for (APIParameterModel apiParameter : apiParameters) {
            ApiParameterLoader.loadParameter(apiParameter, securitySchemeBuilder.getOrCreateParameterBuilder(parameterType, apiParameter.getExternalName()));
        }
    }

    static void loadOperationParameters(List<APIParameterModel> apiParameters, OperationBuilder operationBuilder) {
        for (APIParameterModel apiParameter : apiParameters) {
            String parameterIdentifier = null;
            ParameterBuilder connectorParameterBuilder = operationBuilder.getOrCreateParameterBuilder(ParameterType.valueOf(apiParameter.getParameterType().name()), apiParameter.getExternalName(), parameterIdentifier);
            ApiParameterLoader.loadParameter(apiParameter, connectorParameterBuilder);
        }
    }

    static ParameterBuilder loadParameter(APIParameterModel apiParameter, ParameterBuilder parameterBuilder) {
        parameterBuilder.displayName(apiParameter.getDisplayName()).description(apiParameter.getDescription()).required(apiParameter.isRequired()).defaultValue(apiParameter.getDefaultValue()).password(apiParameter.isPassword()).summary(apiParameter.getSummary());
        ApiTypeLoader.loadTypeDefinition(apiParameter.getTypeModel(), parameterBuilder.getTypeDefinitionBuilder());
        return parameterBuilder;
    }
}

