/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static java.util.Collections.emptyList;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;

public class ParameterBindingBuilder {

  private String name;
  private ParameterType parameterType;
  private TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
  private String value;

  public ParameterBindingBuilder(String name, ParameterType parameterType) {
    requireNonNull(name);
    requireNonNull(parameterType);

    this.name = name;
    this.parameterType = parameterType;
  }

  public ParameterBindingBuilder(ParameterBindingBuilder baseParameterBindingBuilder) {

    this.name = baseParameterBindingBuilder.name;
    this.parameterType = baseParameterBindingBuilder.parameterType;
    this.typeDefinitionBuilder = baseParameterBindingBuilder.typeDefinitionBuilder;
    this.value = baseParameterBindingBuilder.value;
  }

  public String getName() {
    return name;
  }

  public ParameterType getParameterType() {
    return parameterType;
  }

  public TypeDefinitionBuilder getTypeDefinitionBuilder() {
    return typeDefinitionBuilder;
  }

  public ParameterBindingBuilder value(String value) {
    this.value = defaultIfNull(value, this.value);
    return this;
  }

  ParameterBinding build() {
    return new ParameterBinding(parameterType, name, value, false, emptyList(), null);
  }
}
