/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BasicAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BearerAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.DigestAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameters;

public class SecurityDefaultParametersBuilder {

  private SecurityDefaultParametersBuilder builder;

  public BasicAuthBuilder basic() {
    builder = new BasicAuthBuilder();
    return (BasicAuthBuilder) builder;
  }

  public BearerAuthBuilder bearer() {
    builder = new BearerAuthBuilder();
    return (BearerAuthBuilder) builder;
  }

  public DigestAuthBuilder digest() {
    builder = new DigestAuthBuilder();
    return (DigestAuthBuilder) builder;
  }

  protected SecurityDefaultParameters build() {
    if (builder == null) {
      return null;
    }
    return builder.build();
  }

  public static class BasicAuthBuilder extends SecurityDefaultParametersBuilder {

    private SecurityDefaultParameterBuilder username;
    private SecurityDefaultParameterBuilder password;

    public BasicAuthBuilder username(SecurityDefaultParameterBuilder username) {
      this.username = defaultIfNull(username, this.username);
      return this;
    }

    public BasicAuthBuilder password(SecurityDefaultParameterBuilder password) {
      this.password = defaultIfNull(password, this.password);
      return this;
    }

    public BasicAuthDefaultParameters build() {
      return new BasicAuthDefaultParameters(username.build(), password.build());
    }
  }

  public static class BearerAuthBuilder extends SecurityDefaultParametersBuilder {

    private SecurityDefaultParameterBuilder token;

    public BearerAuthBuilder token(SecurityDefaultParameterBuilder token) {
      this.token = defaultIfNull(token, this.token);
      return this;
    }

    public BearerAuthDefaultParameters build() {
      return new BearerAuthDefaultParameters(token.build());
    }
  }

  public static class DigestAuthBuilder extends SecurityDefaultParametersBuilder {

    private SecurityDefaultParameterBuilder username;
    private SecurityDefaultParameterBuilder password;

    public DigestAuthBuilder username(SecurityDefaultParameterBuilder username) {
      this.username = defaultIfNull(username, this.username);
      return this;
    }

    public DigestAuthBuilder password(SecurityDefaultParameterBuilder password) {
      this.password = defaultIfNull(password, this.password);
      return this;
    }

    public DigestAuthDefaultParameters build() {
      return new DigestAuthDefaultParameters(username.build(), password.build());
    }
  }
}
