/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.metadata.OverrideResolver;

import java.util.List;

public class ParameterBinding {

  private final ParameterType parameterType;
  private final String name;
  private final String expression;
  private final boolean ignored;
  private final List<Field> fields;
  private final OverrideResolver overrideResolver;

  public ParameterBinding(ParameterType parameterType, String name, String expression, boolean ignored, List<Field> fields,
                          OverrideResolver overrideResolver) {
    this.parameterType = parameterType;
    this.name = name;
    this.expression = expression;
    this.ignored = ignored;
    this.fields = fields;
    this.overrideResolver = overrideResolver;
  }

  public ParameterType getParameterType() {
    return parameterType;
  }

  public String getName() {
    return name;
  }

  public String getExpression() {
    return expression;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public List<Field> getFields() {
    return fields;
  }

  public OverrideResolver getOverrideResolver() {
    return overrideResolver;
  }
}
