/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.util.List;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

public class Trigger {

  private final String internalName;
  private final String name;
  private final String displayName;
  private final String description;
  private final String alias;

  private final String itemsExpression;
  private final String identityExpression;
  private final String requestBodyExpression;
  private final String eventExpression;
  private final String startValueExpression;

  private final String watermarkExpression;
  private final ParameterDataType watermarkType;

  private final List<TriggerParameter> parameters;
  private final List<ParameterBinding> parameterBindings;

  private final TypeDefinition triggerOutputType;

  private final String outputMediaType;
  private final String muleMetadataScope;
  private final ConnectorOperation operation;

  private ResolverExpression<SampleDataDefinition> sampleData;

  private final boolean sidecar;
  private final String fqn;

  private final boolean refined;

  public Trigger(String name,
                 String displayName,
                 String description,
                 String alias,
                 String itemsExpression,
                 String identityExpression,
                 String requestBodyExpression,
                 String watermarkExpression,
                 ParameterDataType watermarkType,
                 List<TriggerParameter> parameters,
                 List<ParameterBinding> parameterBindings,
                 TypeDefinition triggerOutputType,
                 String outputMediaType,
                 String muleMetadataScope,
                 String eventExpression,
                 String startValueExpression,
                 boolean sidecar,
                 String fqn,
                 boolean refined,
                 ConnectorOperation operation) {

    this.internalName = getXmlName(name);

    this.name = name;
    this.displayName = displayName;
    this.description = description;
    this.alias = alias;
    this.itemsExpression = itemsExpression;
    this.identityExpression = identityExpression;
    this.requestBodyExpression = requestBodyExpression;
    this.watermarkExpression = watermarkExpression;
    this.watermarkType = watermarkType;
    this.parameters = parameters;
    this.parameterBindings = parameterBindings;
    this.eventExpression = eventExpression;
    this.startValueExpression = startValueExpression;
    this.triggerOutputType = triggerOutputType;
    this.outputMediaType = outputMediaType;
    this.muleMetadataScope = muleMetadataScope;
    this.sidecar = sidecar;
    this.fqn = fqn;
    this.refined = refined;

    this.operation = operation;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getName() {
    return name;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getDescription() {
    return description;
  }

  public String getAlias() {
    return alias;
  }

  public String getItemsExpression() {
    return itemsExpression;
  }

  public String getIdentityExpression() {
    return identityExpression;
  }

  public String getWatermarkExpression() {
    return watermarkExpression;
  }

  public ParameterDataType getWatermarkType() {
    return watermarkType;
  }

  public List<TriggerParameter> getParameters() {
    return parameters;
  }

  public List<ParameterBinding> getParameterBindings() {
    return parameterBindings;
  }

  public ConnectorOperation getOperation() {
    return operation;
  }

  public String getRequestBodyExpression() {
    return requestBodyExpression;
  }

  public TypeDefinition getTriggerOutputType() {
    return triggerOutputType;
  }

  public String getOutputMediaType() {
    return outputMediaType;
  }

  public String getMuleMetadataScope() {
    return muleMetadataScope;
  }

  public ResolverExpression<SampleDataDefinition> getSampleData() {
    return sampleData;
  }

  public void setSampleData(ResolverExpression<SampleDataDefinition> sampleData) {
    this.sampleData = sampleData;
  }

  public String getEventExpression() {
    return eventExpression;
  }

  public String getStartValueExpression() {
    return startValueExpression;
  }

  public boolean isSidecar() {
    return sidecar;
  }

  public String getFqn() {
    return fqn;
  }

  public boolean isRefined() {
    return refined;
  }
}
