/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.mulesoft.connectivity.rest.commons.internal.util.MetadataUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBindingBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.BodyBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.documentation.Documentation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.BodyIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationDisplayNameExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ParameterIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorNativeOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.ComparisonUtil;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.ValidationConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationBuilder.class);
    private static final String OUTPUT = "output";
    private static final String DW_MEDIA_TYPE = "application/dw";
    private static final String PAYLOAD = "payload";
    private String fqn;
    private final String apiOperationId;
    private final String path;
    private final String method;
    private List<String> baseUris = new ArrayList<String>();
    private final String apiSummary;
    private String descriptorIdentifier;
    private String displayName;
    private String description;
    private String alias;
    private final List<ParameterBuilder> uriParameterBuilders = new ArrayList<ParameterBuilder>();
    private final List<ParameterBuilder> queryParameterBuilders = new ArrayList<ParameterBuilder>();
    private final List<ParameterBuilder> headerBuilders = new ArrayList<ParameterBuilder>();
    private final BodyBuilder bodyBuilder = new BodyBuilder();
    private final Map<MediaType, TypeDefinitionBuilder> inputMetadataBuilders = new HashMap<MediaType, TypeDefinitionBuilder>();
    private final Map<MediaType, TypeDefinitionBuilder> outputMetadataBuilders = new HashMap<MediaType, TypeDefinitionBuilder>();
    private List<String> securitySchemeIds = new ArrayList<String>();
    private String alternativeBaseUri;
    private String pagination;
    private Boolean skipOutputTypeValidation;
    private Boolean isVoidOperation;
    private QueryParamArrayFormat queryParamArrayFormat;
    private Boolean ignored;
    private Boolean privateOperation;
    private SampleDataBuilder sampleDataBuilder = new SampleDataBuilder();
    private MediaType defaultInputMediaType;
    private MediaType defaultOutputMediaType;
    private String forcedOutputTypeSchema;
    private String forcedInputTypeSchema;
    private String muleOutputResolver;
    private boolean isAdapter = false;
    private boolean isSidecar = false;
    private boolean isRefined = false;
    private final List<AuxiliarParameterBuilder> parameters = new ArrayList<AuxiliarParameterBuilder>();
    private final List<AuxiliarParameterBindingBuilder> requestBindingBuilders = new ArrayList<AuxiliarParameterBindingBuilder>();
    private final List<AuxiliarParameterBindingBuilder> responseBindingBuilders = new ArrayList<AuxiliarParameterBindingBuilder>();
    private final Documentation documentation;

    OperationBuilder(String descriptorIdentifier, String fqn) {
        this.descriptorIdentifier = descriptorIdentifier;
        this.fqn = fqn;
        this.apiOperationId = null;
        this.path = null;
        this.method = null;
        this.apiSummary = null;
        this.documentation = null;
    }

    OperationBuilder(String descriptorIdentifier, OperationBuilder baseOperationBuilder) {
        this.descriptorIdentifier = descriptorIdentifier;
        this.method = baseOperationBuilder.method;
        this.path = baseOperationBuilder.path;
        this.baseUris = baseOperationBuilder.baseUris;
        this.apiSummary = baseOperationBuilder.apiSummary;
        this.apiOperationId = null;
        this.displayName = baseOperationBuilder.displayName;
        this.description = baseOperationBuilder.description;
        this.uriParameterBuilders.addAll(baseOperationBuilder.uriParameterBuilders);
        this.queryParameterBuilders.addAll(baseOperationBuilder.queryParameterBuilders);
        this.headerBuilders.addAll(baseOperationBuilder.headerBuilders);
        this.inputMetadataBuilders.putAll(baseOperationBuilder.inputMetadataBuilders);
        this.outputMetadataBuilders.putAll(baseOperationBuilder.outputMetadataBuilders);
        this.securitySchemeIds(baseOperationBuilder.securitySchemeIds);
        this.alternativeBaseUri = baseOperationBuilder.alternativeBaseUri;
        this.pagination = baseOperationBuilder.pagination;
        this.skipOutputTypeValidation = baseOperationBuilder.skipOutputTypeValidation;
        this.isVoidOperation = baseOperationBuilder.isVoidOperation;
        this.queryParamArrayFormat = baseOperationBuilder.queryParamArrayFormat;
        this.ignored = baseOperationBuilder.ignored;
        this.privateOperation = baseOperationBuilder.privateOperation;
        this.alias = baseOperationBuilder.alias;
        this.sampleDataBuilder = new SampleDataBuilder(baseOperationBuilder.sampleDataBuilder);
        this.defaultInputMediaType = baseOperationBuilder.defaultInputMediaType;
        this.defaultOutputMediaType = baseOperationBuilder.defaultOutputMediaType;
        this.forcedOutputTypeSchema = baseOperationBuilder.forcedOutputTypeSchema;
        this.forcedInputTypeSchema = baseOperationBuilder.forcedInputTypeSchema;
        this.isAdapter = baseOperationBuilder.isAdapter;
        this.documentation = baseOperationBuilder.documentation;
    }

    OperationBuilder(String apiOperationId, String path, String method, String apiSummary, Documentation documentation) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(method);
        this.method = method;
        this.path = path;
        this.apiOperationId = apiOperationId;
        this.apiSummary = apiSummary;
        this.descriptorIdentifier = null;
        this.documentation = documentation;
    }

    public OperationBuilder displayName(String displayName) {
        this.displayName = (String)ObjectUtils.defaultIfNull((Object)displayName, (Object)this.displayName);
        return this;
    }

    public OperationBuilder descriptorIdentifier(String descriptorIdentifier) {
        this.descriptorIdentifier = (String)ObjectUtils.defaultIfNull((Object)descriptorIdentifier, (Object)this.descriptorIdentifier);
        return this;
    }

    public OperationBuilder description(String description) {
        this.description = (String)ObjectUtils.defaultIfNull((Object)description, (Object)this.description);
        return this;
    }

    public OperationBuilder alias(String alias) {
        this.alias = (String)ObjectUtils.defaultIfNull((Object)alias, (Object)this.alias);
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public OperationBuilder securitySchemes(List<String> securitySchemeIds) {
        this.securitySchemeIds = (List)ObjectUtils.defaultIfNull(securitySchemeIds, this.securitySchemeIds);
        return this;
    }

    public OperationBuilder alternativeBaseUri(String alternativeBaseUri) {
        this.alternativeBaseUri = (String)ObjectUtils.defaultIfNull((Object)alternativeBaseUri, (Object)this.alternativeBaseUri);
        return this;
    }

    public boolean hasPagination() {
        return StringUtils.isNotBlank((CharSequence)this.pagination);
    }

    public OperationBuilder pagination(String pagination) {
        this.pagination = (String)ObjectUtils.defaultIfNull((Object)pagination, (Object)this.pagination);
        return this;
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }

    public OperationBuilder skipOutputTypeValidation(Boolean skipOutputTypeValidation) {
        this.skipOutputTypeValidation = (Boolean)ObjectUtils.defaultIfNull((Object)skipOutputTypeValidation, (Object)this.skipOutputTypeValidation);
        return this;
    }

    public Boolean getIsVoidOperation() {
        return this.isVoidOperation;
    }

    public OperationBuilder voidOperation(Boolean isVoidOperation) {
        this.isVoidOperation = (Boolean)ObjectUtils.defaultIfNull((Object)isVoidOperation, (Object)this.isVoidOperation);
        return this;
    }

    public Boolean isIgnored() {
        return this.ignored;
    }

    public OperationBuilder ignored(Boolean ignored) {
        this.ignored = (Boolean)ObjectUtils.defaultIfNull((Object)ignored, (Object)this.ignored);
        return this;
    }

    public Boolean isPrivateOperation() {
        return this.privateOperation;
    }

    public OperationBuilder privateOperation(Boolean privateOperation) {
        this.privateOperation = (Boolean)ObjectUtils.defaultIfNull((Object)privateOperation, (Object)this.privateOperation);
        return this;
    }

    public OperationBuilder queryParamArrayFormat(QueryParamArrayFormat queryParamArrayFormat) {
        this.queryParamArrayFormat = (QueryParamArrayFormat)((Object)ObjectUtils.defaultIfNull((Object)((Object)queryParamArrayFormat), (Object)((Object)this.queryParamArrayFormat)));
        return this;
    }

    public MediaType getDefaultInputMediaType() {
        return this.defaultInputMediaType;
    }

    public OperationBuilder setDefaultInputMediaType(MediaType defaultInputMediaType) {
        this.defaultInputMediaType = (MediaType)ObjectUtils.defaultIfNull((Object)defaultInputMediaType, (Object)this.defaultInputMediaType);
        return this;
    }

    public MediaType getDefaultOutputMediaType() {
        return this.defaultOutputMediaType;
    }

    public OperationBuilder setDefaultOutputMediaType(MediaType defaultOutputMediaType) {
        this.defaultOutputMediaType = (MediaType)ObjectUtils.defaultIfNull((Object)defaultOutputMediaType, (Object)this.defaultOutputMediaType);
        return this;
    }

    public OperationBuilder parameters(List<AuxiliarParameterBuilder> parameters) {
        this.parameters.clear();
        this.parameters.addAll(parameters);
        return this;
    }

    public OperationBuilder requestBindings(List<AuxiliarParameterBindingBuilder> requestBindings) {
        this.requestBindingBuilders.clear();
        if (requestBindings != null) {
            this.requestBindingBuilders.addAll(requestBindings);
        }
        return this;
    }

    public OperationBuilder responseBindings(List<AuxiliarParameterBindingBuilder> responseBindings) {
        this.responseBindingBuilders.clear();
        if (responseBindings != null) {
            this.responseBindingBuilders.addAll(responseBindings);
        }
        return this;
    }

    public OperationBuilder baseUris(List<String> baseUris) {
        this.baseUris.clear();
        if (baseUris != null) {
            this.baseUris.addAll(baseUris);
        }
        return this;
    }

    public OperationBuilder uriParameters(List<ParameterBuilder> uriParameters) {
        this.uriParameterBuilders.clear();
        if (uriParameters != null) {
            this.uriParameterBuilders.addAll(uriParameters);
        }
        return this;
    }

    public OperationBuilder queryParameters(List<ParameterBuilder> queryParameterBuilders) {
        this.queryParameterBuilders.clear();
        if (queryParameterBuilders != null) {
            this.queryParameterBuilders.addAll(queryParameterBuilders);
        }
        return this;
    }

    public OperationBuilder headers(List<ParameterBuilder> headerBuilders) {
        this.headerBuilders.clear();
        if (headerBuilders != null) {
            this.headerBuilders.addAll(headerBuilders);
        }
        return this;
    }

    public OperationBuilder securitySchemeIds(List<String> securitySchemeIds) {
        if (this.securitySchemeIds == null) {
            this.securitySchemeIds = new ArrayList<String>();
        } else {
            this.securitySchemeIds.clear();
        }
        this.securitySchemeIds.addAll(securitySchemeIds);
        return this;
    }

    public OperationBuilder adapter() {
        this.isAdapter = true;
        return this;
    }

    public OperationBuilder sidecar() {
        this.isSidecar = true;
        return this;
    }

    public OperationBuilder refined(Boolean refined) {
        this.isRefined = (Boolean)ObjectUtils.defaultIfNull((Object)refined, (Object)this.isRefined);
        return this;
    }

    public String getDescriptorIdentifier() {
        return this.descriptorIdentifier;
    }

    public String getPath() {
        return this.path;
    }

    public String getApiOperationId() {
        return this.apiOperationId;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isAdapter() {
        return this.isAdapter;
    }

    public boolean hasForcedOutputTypeSchema() {
        return this.forcedOutputTypeSchema != null;
    }

    public OperationBuilder forceOutputTypeSchema(String forcedOutputTypeSchema) {
        this.forcedOutputTypeSchema = (String)ObjectUtils.defaultIfNull((Object)forcedOutputTypeSchema, (Object)this.forcedOutputTypeSchema);
        return this;
    }

    public boolean hasForcedInputTypeSchema() {
        return this.forcedInputTypeSchema != null;
    }

    public String getFqn() {
        return this.fqn;
    }

    public OperationBuilder forceInputTypeSchema(String forcedInputTypeSchema) {
        this.forcedInputTypeSchema = (String)ObjectUtils.defaultIfNull((Object)forcedInputTypeSchema, (Object)this.forcedInputTypeSchema);
        return this;
    }

    public OperationBuilder muleOutputResolver(String muleOutputResolver) {
        this.muleOutputResolver = (String)ObjectUtils.defaultIfNull((Object)muleOutputResolver, (Object)this.muleOutputResolver);
        return this;
    }

    public List<TypeDefinitionBuilder> getMultipartInputMetadataBuilders() {
        return this.inputMetadataBuilders.values().stream().filter(TypeDefinitionBuilder::isMultipart).collect(Collectors.toList());
    }

    public Map<MediaType, TypeDefinitionBuilder> getInputMetadataBuilders() {
        return this.inputMetadataBuilders;
    }

    public TypeDefinitionBuilder getOrCreateInputMetadataBuilder(MediaType mediaType) {
        return this.getOrCreateTypeDefinitionBuilder(this.inputMetadataBuilders, mediaType);
    }

    public Map<MediaType, TypeDefinitionBuilder> getOutputMetadataBuilders() {
        return this.outputMetadataBuilders;
    }

    public TypeDefinitionBuilder getOrCreateOutputMetadataBuilder(MediaType mediaType) {
        return this.getOrCreateTypeDefinitionBuilder(this.outputMetadataBuilders, mediaType);
    }

    private TypeDefinitionBuilder getOrCreateTypeDefinitionBuilder(Map<MediaType, TypeDefinitionBuilder> map, MediaType mediaType) {
        TypeDefinitionBuilder typeDefinitionBuilder = map.get(mediaType);
        if (typeDefinitionBuilder == null) {
            typeDefinitionBuilder = new TypeDefinitionBuilder();
            map.put(mediaType, typeDefinitionBuilder);
        }
        return typeDefinitionBuilder;
    }

    public ParameterBuilder getOrCreateParameterBuilder(ParameterType parameterType, String externalName, String parameterIdentifier) {
        List<ParameterBuilder> parameterBuilders = this.getParameterBuilders(parameterType);
        ParameterBuilder paramBuilder = parameterBuilders.stream().filter(x -> ComparisonUtil.externalNameParamsComparison(x.getExternalName(), externalName, parameterType)).findFirst().orElse(null);
        if (paramBuilder == null) {
            paramBuilder = new ParameterBuilder(parameterType, externalName, parameterIdentifier);
            parameterBuilders.add(paramBuilder);
        }
        return paramBuilder;
    }

    public List<String> getBaseUris() {
        return this.baseUris;
    }

    private List<ParameterBuilder> getParameterBuilders(ParameterType parameterType) {
        switch (parameterType) {
            case URI: {
                return this.uriParameterBuilders;
            }
            case QUERY: {
                return this.queryParameterBuilders;
            }
            case HEADER: {
                return this.headerBuilders;
            }
        }
        throw new IllegalArgumentException("Parameter Type not supported. This is a bug.");
    }

    public SampleDataBuilder getSampleDataBuilder() {
        return this.sampleDataBuilder;
    }

    ConnectorOperation build() {
        return new ConnectorNativeOperation(this.descriptorIdentifier, this.privateOperation != null && this.privateOperation != false, this.fqn);
    }

    ConnectorOperation build(OperationIdentifierExpressionHandler identifierHandler, OperationDisplayNameExpressionHandler displayNameHandler, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler, BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler, TypeSchemaPool typeSchemaPool, List<Pagination> paginations, List<ConnectorSecurityScheme> securitySchemes, MediaType globalDefaultInputMediaType, MediaType globalDefaultOutputMediaType, QueryParamArrayFormat globalQueryParamArrayFormat, Boolean globalSkipOutputTypeValidation) {
        Pagination pagination = this.pagination != null ? paginations.stream().filter(x -> x.getName().equals(this.pagination)).findFirst().orElseThrow(() -> new IllegalArgumentException("Pagination not found. This is a bug.")) : null;
        this.addPartIdentifiersForMultipartScenarios(bodyIdentifierExpressionHandler, this.apiOperationId, this.method, this.path);
        List<ParameterBinding> responseBindings = this.buildParameterBindings(this.responseBindingBuilders);
        TypeDefinition outputMetadataTypeDefinition = this.buildOutputType(this.outputMetadataBuilders, this.forcedOutputTypeSchema, (MediaType)ObjectUtils.defaultIfNull((Object)this.defaultOutputMediaType, (Object)globalDefaultOutputMediaType), typeSchemaPool, pagination != null ? pagination.getPaginationResponseExpression() : null, this.isDynamicSchema(responseBindings));
        ConnectorOperation operation = new ConnectorOperation(this.descriptorIdentifier != null ? this.descriptorIdentifier : identifierHandler.evaluate(this.apiOperationId, this.method, this.path), this.buildOperationDisplayName(displayNameHandler), this.description, this.buildOperationSummary(), this.path, this.alias, this.baseUris, HTTPMethod.fromString(this.method), this.buildParameters(this.uriParameterBuilders, typeSchemaPool, parameterIdentifierExpressionHandler), this.buildParameters(this.queryParameterBuilders, typeSchemaPool, parameterIdentifierExpressionHandler), this.buildHeaders(this.headerBuilders, typeSchemaPool, parameterIdentifierExpressionHandler), this.buildAuxiliarParameters(this.parameters, typeSchemaPool), this.buildParameterBindings(this.requestBindingBuilders), responseBindings, this.buildBody(bodyIdentifierExpressionHandler), this.buildInputType(this.inputMetadataBuilders, this.forcedInputTypeSchema, (MediaType)ObjectUtils.defaultIfNull((Object)this.defaultInputMediaType, (Object)globalDefaultInputMediaType), typeSchemaPool), outputMetadataTypeDefinition, this.muleOutputResolver, this.buildSecuritySchemes(securitySchemes), this.alternativeBaseUri, pagination, (Boolean)ObjectUtils.defaultIfNull((Object)this.skipOutputTypeValidation, (Object)globalSkipOutputTypeValidation), this.isVoidOperation, this.buildQueryParamArrayFormat(globalQueryParamArrayFormat), this.ignored != null && this.ignored != false, this.privateOperation != null && this.privateOperation != false, this.isAdapter, this.isSidecar, this.fqn, this.isRefined, this.hasForcedOutputTypeSchema(), this.documentation);
        operation.setSampleData(this.sampleDataBuilder.build(operation) != null ? this.sampleDataBuilder.build(operation) : this.buildExampleSampleData(outputMetadataTypeDefinition));
        return operation;
    }

    private void addPartIdentifiersForMultipartScenarios(BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler, String apiOperationId, String method, String path) {
        this.inputMetadataBuilders.entrySet().stream().filter(entry -> MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible((MediaType)entry.getKey()) && ((TypeDefinitionBuilder)entry.getValue()).getParts() != null).forEach(entry -> ((TypeDefinitionBuilder)entry.getValue()).getParts().stream().filter(parameterBuilder -> parameterBuilder.getParameterIdentifier() == null).forEach(parameterBuilder -> {
            String partName = parameterBuilder.getExternalName();
            String partNameIdentifier = bodyIdentifierExpressionHandler.evaluate(apiOperationId, method, path, partName);
            parameterBuilder.parameterIdentifier(partNameIdentifier);
        }));
    }

    private Body buildBody(BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler) {
        return this.bodyBuilder.buildBody(bodyIdentifierExpressionHandler, StringUtils.isNotBlank((CharSequence)this.descriptorIdentifier) ? this.descriptorIdentifier : this.apiOperationId, this.method, this.path);
    }

    private List<ParameterBinding> buildParameterBindings(List<AuxiliarParameterBindingBuilder> bindings) {
        return bindings.stream().map(AuxiliarParameterBindingBuilder::build).collect(Collectors.toList());
    }

    public BodyBuilder getBodyBuilder() {
        return this.bodyBuilder;
    }

    private Optional<ConnectorSecurityScheme> getCustomSecuritiesScheme(List<ConnectorSecurityScheme> securitySchemes) {
        return securitySchemes.stream().filter(x -> x.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION)).filter(x -> ((CustomAuthenticationScheme)x).getFqn().isPresent()).findAny();
    }

    private Optional<ConnectorSecurityScheme> getUnsecuredSecuritiesScheme(List<ConnectorSecurityScheme> securitySchemes) {
        return securitySchemes.stream().filter(x -> x.getName().equalsIgnoreCase(ConnectorSecurityScheme.SecuritySchemeType.UNSECURED.toString())).findAny();
    }

    private Optional<ConnectorSecurityScheme> getMockedSecuritiesScheme(List<ConnectorSecurityScheme> securitySchemes) {
        return securitySchemes.stream().filter(x -> x.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.MOCKED)).findAny();
    }

    private List<ConnectorSecurityScheme> buildSecuritySchemes(List<ConnectorSecurityScheme> securitySchemes) {
        if (this.securitySchemeIds == null || this.securitySchemeIds.isEmpty()) {
            ArrayList<ConnectorSecurityScheme> operationSecuritySchemes = new ArrayList<ConnectorSecurityScheme>();
            this.getCustomSecuritiesScheme(securitySchemes).ifPresent(operationSecuritySchemes::add);
            if (operationSecuritySchemes.isEmpty()) {
                this.getUnsecuredSecuritiesScheme(securitySchemes).ifPresent(operationSecuritySchemes::add);
                if (operationSecuritySchemes.isEmpty()) {
                    throw new IllegalStateException("There should be at least an unsecured security scheme. This is a bug.");
                }
            }
            this.getMockedSecuritiesScheme(securitySchemes).ifPresent(operationSecuritySchemes::add);
            return operationSecuritySchemes;
        }
        return securitySchemes.stream().filter(x -> this.securitySchemeIds.contains(x.getName()) || x.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION) || x.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.MOCKED)).collect(Collectors.toList());
    }

    private QueryParamArrayFormat buildQueryParamArrayFormat(QueryParamArrayFormat globalQueryParamArrayFormat) {
        return (QueryParamArrayFormat)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.queryParamArrayFormat), (Object)((Object)globalQueryParamArrayFormat)));
    }

    private TypeDefinition buildInputType(Map<MediaType, TypeDefinitionBuilder> builders, String forcedTypeSchema, MediaType defaultMediaType, TypeSchemaPool typeSchemaPool) {
        TypeDefinitionBuilder typeBuilder = this.getTypeDefinitionBuilderForMediaTypeOrDefault(builders, defaultMediaType);
        if (typeBuilder != null) {
            return typeBuilder.build(typeSchemaPool, forcedTypeSchema);
        }
        if (forcedTypeSchema != null) {
            return new TypeDefinitionBuilder().object().build(typeSchemaPool, forcedTypeSchema);
        }
        return null;
    }

    private TypeDefinition buildOutputType(Map<MediaType, TypeDefinitionBuilder> builders, String forcedTypeSchema, MediaType defaultMediaType, TypeSchemaPool typeSchemaPool, String itemExpression, boolean isDynamicSchema) {
        TypeDefinitionBuilder typeBuilder = this.getTypeDefinitionBuilderForMediaTypeOrDefault(builders, defaultMediaType);
        if (typeBuilder != null) {
            return typeBuilder.build(typeSchemaPool, forcedTypeSchema, itemExpression, MetadataUtils.LocationType.ARRAY, isDynamicSchema);
        }
        if (forcedTypeSchema != null) {
            return new TypeDefinitionBuilder().object().build(typeSchemaPool, forcedTypeSchema);
        }
        return null;
    }

    private boolean isDynamicSchema(List<ParameterBinding> responseBindings) {
        Optional<ParameterBinding> bodyBinding = responseBindings.stream().filter(bindings -> bindings.getParameterType().equals((Object)ParameterType.BODY)).findFirst();
        return bodyBinding.map(parameterBinding -> parameterBinding.getFields().stream().map(Field::getOverrideResolver).filter(Objects::nonNull).findFirst().orElse(parameterBinding.getOverrideResolver())).isPresent();
    }

    private List<Parameter> buildHeaders(List<ParameterBuilder> headerBuilders, TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler) {
        return this.buildParameters(headerBuilders.stream().filter(x -> !x.getExternalName().equalsIgnoreCase("accept")).collect(Collectors.toList()), typeSchemaPool, parameterIdentifierExpressionHandler);
    }

    private List<Parameter> buildParameters(List<ParameterBuilder> parameterBuilders, TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler) {
        return parameterBuilders.stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(x -> x.buildParameter(typeSchemaPool, parameterIdentifierExpressionHandler)).collect(Collectors.toList());
    }

    private List<AuxiliarParameter> buildAuxiliarParameters(List<AuxiliarParameterBuilder> parameterBuilders, TypeSchemaPool typeSchemaPool) {
        return parameterBuilders.stream().map(x -> x.build(typeSchemaPool)).collect(Collectors.toList());
    }

    private boolean isSampleDataAutogeneratedMediaTypeAllowed(TypeDefinition outputMetadataTypeDefinition) {
        return outputMetadataTypeDefinition != null && outputMetadataTypeDefinition.getExample() != null && outputMetadataTypeDefinition.getMediaType() != null && ValidationConstants.ALLOWED_MEDIA_TYPES_FOR_EXAMPLE.stream().anyMatch(x -> x.equals(outputMetadataTypeDefinition.getMediaType().toString()));
    }

    private ResolverExpression<SampleDataDefinition> buildExampleSampleData(TypeDefinition outputMetadataTypeDefinition) {
        Optional<String> result;
        if (this.isSampleDataAutogeneratedMediaTypeAllowed(outputMetadataTypeDefinition) && (result = this.transformExample(outputMetadataTypeDefinition)).isPresent()) {
            return new SampleDataBuilder().inline().scriptReturnValue(result.get()).build();
        }
        return null;
    }

    private Optional<String> transformExample(TypeDefinition outputMetadataTypeDefinition) {
        try {
            String example = outputMetadataTypeDefinition.getMediaType().toString().equals("application/json") ? OperationBuilder.transformYamlExampleIntoJSON(outputMetadataTypeDefinition.getExample()) : outputMetadataTypeDefinition.getExample();
            return Optional.of(this.dataWeaveTransformation(example, outputMetadataTypeDefinition.getMediaType()));
        }
        catch (Exception e) {
            LOGGER.warn(String.format("An exception occurred while transformation sample data example. %s", e.getMessage()));
            return Optional.ofNullable(null);
        }
    }

    private String dataWeaveTransformation(String example, MediaType outputMediaType) {
        DataWeaveScriptingEngine scriptingEngine = new DataWeaveScriptingEngine();
        String exampleTransformed = scriptingEngine.compile(String.format("%s %s --- %s", OUTPUT, DW_MEDIA_TYPE, PAYLOAD), new String[]{PAYLOAD}).write(new ScriptingBindings().addBinding(PAYLOAD, (Object)example, outputMediaType.toString()), ServiceManager.apply()).getContentAsString();
        return String.format("%s %s --- %s", OUTPUT, outputMediaType, exampleTransformed);
    }

    private static String transformYamlExampleIntoJSON(String example) throws JsonProcessingException {
        Optional<JsonNode> jsonNode = OperationBuilder.isValidJson(example);
        if (jsonNode.isPresent()) {
            return OperationBuilder.getDefaultObjectMapper().writeValueAsString((Object)jsonNode.get());
        }
        JsonNode obj = OperationBuilder.getObjectMapper((JsonFactory)new YAMLFactory()).readTree(example);
        return OperationBuilder.getDefaultObjectMapper().writeValueAsString((Object)obj);
    }

    private static Optional<JsonNode> isValidJson(String example) {
        try {
            return Optional.of(OperationBuilder.getDefaultObjectMapper().readTree(example));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    private static ObjectMapper getObjectMapper(JsonFactory factory) {
        ObjectMapper objectMapper = factory != null ? new ObjectMapper(factory) : new ObjectMapper();
        return objectMapper.findAndRegisterModules().activateDefaultTyping((PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().build(), ObjectMapper.DefaultTyping.NON_FINAL);
    }

    private static ObjectMapper getDefaultObjectMapper() {
        return OperationBuilder.getObjectMapper(null);
    }

    private TypeDefinitionBuilder getTypeDefinitionBuilderForMediaTypeOrDefault(Map<MediaType, TypeDefinitionBuilder> builders, MediaType mediaType) {
        if (builders == null || builders.isEmpty()) {
            return null;
        }
        if (mediaType == null) {
            return this.getDefaultTypeDefinitionBuilder(builders);
        }
        TypeDefinitionBuilder typeDefinitionBuilder = builders.get(mediaType);
        if (typeDefinitionBuilder != null) {
            return typeDefinitionBuilder;
        }
        return this.getDefaultTypeDefinitionBuilder(builders);
    }

    private TypeDefinitionBuilder getDefaultTypeDefinitionBuilder(Map<MediaType, TypeDefinitionBuilder> builders) {
        if (builders.get(MediaType.APPLICATION_JSON_TYPE) != null) {
            return builders.get(MediaType.APPLICATION_JSON_TYPE);
        }
        if (builders.get(MediaType.APPLICATION_XML_TYPE) != null) {
            return builders.get(MediaType.APPLICATION_XML_TYPE);
        }
        return builders.values().stream().findFirst().orElse(null);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ParameterBuilder> getUriParameters() {
        return Collections.unmodifiableList(this.uriParameterBuilders);
    }

    public List<ParameterBuilder> getQueryParameters() {
        return Collections.unmodifiableList(this.queryParameterBuilders);
    }

    public List<ParameterBuilder> getHeaders() {
        return Collections.unmodifiableList(this.headerBuilders);
    }

    public Map<MediaType, TypeDefinitionBuilder> getInputMetadata() {
        return this.inputMetadataBuilders;
    }

    public HTTPMethod getHttpMethod() {
        return HTTPMethod.fromString(this.method);
    }

    private String buildOperationDisplayName(OperationDisplayNameExpressionHandler displayNameHandler) {
        return this.isAdapter && this.displayName != null ? this.displayName : displayNameHandler.evaluate(this.apiOperationId, this.method, this.path);
    }

    private String buildOperationSummary() {
        if (this.isAdapter) {
            return !StringUtils.isEmpty((CharSequence)this.apiSummary) ? this.apiSummary : null;
        }
        return !StringUtils.isEmpty((CharSequence)this.apiSummary) ? this.apiSummary : (!StringUtils.isEmpty((CharSequence)this.displayName) ? this.displayName : null);
    }
}

