/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationKind;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class PaginationBuilder {
    private final String name;
    private PaginationKind kind;
    private String paginationParameterName;
    private String nextTokenExpression;
    private String initialOffset;
    private String initialPageNumber;
    private String pagingResponseExpression;
    private String pageCountExpression;
    private String nextUrlExpression;

    PaginationBuilder(String name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PaginationBuilder kind(PaginationKind kind) {
        this.kind = (PaginationKind)((Object)ObjectUtils.defaultIfNull((Object)((Object)kind), (Object)((Object)this.kind)));
        return this;
    }

    public PaginationBuilder paginationParameterName(String paginationParameterName) {
        this.paginationParameterName = (String)ObjectUtils.defaultIfNull((Object)paginationParameterName, (Object)this.paginationParameterName);
        return this;
    }

    public PaginationBuilder nextTokenExpression(String nextTokenExpression) {
        this.nextTokenExpression = (String)ObjectUtils.defaultIfNull((Object)nextTokenExpression, (Object)this.nextTokenExpression);
        return this;
    }

    public PaginationBuilder initialOffset(String initialOffset) {
        this.initialOffset = (String)ObjectUtils.defaultIfNull((Object)initialOffset, (Object)this.initialOffset);
        return this;
    }

    public PaginationBuilder initialPageNumber(String initialPageNumber) {
        this.initialPageNumber = (String)ObjectUtils.defaultIfNull((Object)initialPageNumber, (Object)this.initialPageNumber);
        return this;
    }

    public PaginationBuilder pagingResponseExpression(String pagingResponseExpression) {
        this.pagingResponseExpression = (String)ObjectUtils.defaultIfNull((Object)pagingResponseExpression, (Object)this.pagingResponseExpression);
        return this;
    }

    public PaginationBuilder pageCountExpression(String pageCountExpression) {
        this.pageCountExpression = (String)ObjectUtils.defaultIfNull((Object)pageCountExpression, (Object)this.pageCountExpression);
        return this;
    }

    public PaginationBuilder nextUrlExpression(String nextUrlExpression) {
        this.nextUrlExpression = (String)ObjectUtils.defaultIfNull((Object)nextUrlExpression, (Object)this.nextUrlExpression);
        return this;
    }

    Pagination build() {
        Objects.requireNonNull(this.kind);
        return new Pagination(this.name, this.kind, this.paginationParameterName, this.nextTokenExpression, this.initialOffset, this.initialPageNumber, this.pagingResponseExpression, this.pageCountExpression, this.nextUrlExpression);
    }
}

