/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class ParameterBindingBuilder {
    private String name;
    private ParameterType parameterType;
    private TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
    private String value;

    public ParameterBindingBuilder(String name, ParameterType parameterType) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(parameterType);
        this.name = name;
        this.parameterType = parameterType;
    }

    public ParameterBindingBuilder(ParameterBindingBuilder baseParameterBindingBuilder) {
        this.name = baseParameterBindingBuilder.name;
        this.parameterType = baseParameterBindingBuilder.parameterType;
        this.typeDefinitionBuilder = baseParameterBindingBuilder.typeDefinitionBuilder;
        this.value = baseParameterBindingBuilder.value;
    }

    public String getName() {
        return this.name;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public TypeDefinitionBuilder getTypeDefinitionBuilder() {
        return this.typeDefinitionBuilder;
    }

    public ParameterBindingBuilder value(String value) {
        this.value = (String)ObjectUtils.defaultIfNull((Object)value, (Object)this.value);
        return this;
    }

    ParameterBinding build() {
        return new ParameterBinding(this.parameterType, this.name, this.value, false, Collections.emptyList(), null);
    }
}

